/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.amqp.spring;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.amqp.AMQPMessageConverter;
import org.axonframework.serializer.UnknownSerializedTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;

public class ClusterMessageListener
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(ClusterMessageListener.class);
    private final List<Cluster> clusters = new CopyOnWriteArrayList<Cluster>();
    private final AMQPMessageConverter messageConverter;

    public ClusterMessageListener(Cluster initialCluster, AMQPMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
        this.clusters.add(initialCluster);
    }

    public void onMessage(Message message) {
        try {
            EventMessage eventMessage = this.messageConverter.readAMQPMessage(message.getBody(), message.getMessageProperties().getHeaders());
            if (eventMessage != null) {
                for (Cluster cluster : this.clusters) {
                    cluster.publish(new EventMessage[]{eventMessage});
                }
            }
        }
        catch (UnknownSerializedTypeException e) {
            logger.warn("Unable to deserialize an incoming message. Ignoring it. {}", (Object)e.toString());
        }
    }

    public void addCluster(Cluster cluster) {
        this.clusters.add(cluster);
    }
}

