/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.amqp.spring;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Command;
import com.rabbitmq.client.ConfirmListener;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.FlowListener;
import com.rabbitmq.client.GetResponse;
import com.rabbitmq.client.Method;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownListener;
import com.rabbitmq.client.ShutdownSignalException;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.rabbit.connection.Connection;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionListener;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;

public class ExtendedMessageListenerContainer
extends SimpleMessageListenerContainer {
    private volatile boolean isExclusive = true;

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        if (this.isExclusive) {
            super.setConnectionFactory((ConnectionFactory)new ExclusiveConnectionFactory(connectionFactory));
        } else {
            super.setConnectionFactory(connectionFactory);
        }
    }

    public void setExclusive(boolean exclusive) {
        this.isExclusive = exclusive;
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory instanceof ExclusiveConnectionFactory) {
            this.setConnectionFactory(((ExclusiveConnectionFactory)connectionFactory).getDelegate());
        }
        if (exclusive) {
            this.setConcurrentConsumers(1);
        }
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        super.setConcurrentConsumers(concurrentConsumers);
        if (concurrentConsumers > 1) {
            this.setExclusive(false);
        }
    }

    private static class ExclusiveChannel
    implements Channel {
        private final Channel delegate;

        public ExclusiveChannel(Channel delegate) {
            this.delegate = delegate;
        }

        public int getChannelNumber() {
            return this.delegate.getChannelNumber();
        }

        public com.rabbitmq.client.Connection getConnection() {
            return this.delegate.getConnection();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public void close(int closeCode, String closeMessage) throws IOException {
            this.delegate.close(closeCode, closeMessage);
        }

        public AMQP.Channel.FlowOk flow(boolean active) throws IOException {
            return this.delegate.flow(active);
        }

        public AMQP.Channel.FlowOk getFlow() {
            return this.delegate.getFlow();
        }

        public void abort() throws IOException {
            this.delegate.abort();
        }

        public void abort(int closeCode, String closeMessage) throws IOException {
            this.delegate.abort(closeCode, closeMessage);
        }

        public void addReturnListener(ReturnListener listener) {
            this.delegate.addReturnListener(listener);
        }

        public boolean removeReturnListener(ReturnListener listener) {
            return this.delegate.removeReturnListener(listener);
        }

        public void clearReturnListeners() {
            this.delegate.clearReturnListeners();
        }

        public void addFlowListener(FlowListener listener) {
            this.delegate.addFlowListener(listener);
        }

        public boolean removeFlowListener(FlowListener listener) {
            return this.delegate.removeFlowListener(listener);
        }

        public void clearFlowListeners() {
            this.delegate.clearFlowListeners();
        }

        public void addConfirmListener(ConfirmListener listener) {
            this.delegate.addConfirmListener(listener);
        }

        public boolean removeConfirmListener(ConfirmListener listener) {
            return this.delegate.removeConfirmListener(listener);
        }

        public void clearConfirmListeners() {
            this.delegate.clearConfirmListeners();
        }

        public Consumer getDefaultConsumer() {
            return this.delegate.getDefaultConsumer();
        }

        public void setDefaultConsumer(Consumer consumer) {
            this.delegate.setDefaultConsumer(consumer);
        }

        public void basicQos(int prefetchSize, int prefetchCount, boolean global) throws IOException {
            this.delegate.basicQos(prefetchSize, prefetchCount, global);
        }

        public void basicQos(int prefetchCount) throws IOException {
            this.delegate.basicQos(prefetchCount);
        }

        public void basicPublish(String exchange, String routingKey, AMQP.BasicProperties props, byte[] body) throws IOException {
            this.delegate.basicPublish(exchange, routingKey, props, body);
        }

        public void basicPublish(String exchange, String routingKey, boolean mandatory, AMQP.BasicProperties props, byte[] body) throws IOException {
            this.delegate.basicPublish(exchange, routingKey, mandatory, props, body);
        }

        public void basicPublish(String exchange, String routingKey, boolean mandatory, boolean immediate, AMQP.BasicProperties props, byte[] body) throws IOException {
            this.delegate.basicPublish(exchange, routingKey, mandatory, immediate, props, body);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, arguments);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclare(String exchange, String type, boolean durable, boolean autoDelete, boolean internal, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeDeclare(exchange, type, durable, autoDelete, internal, arguments);
        }

        public AMQP.Exchange.DeclareOk exchangeDeclarePassive(String name) throws IOException {
            return this.delegate.exchangeDeclarePassive(name);
        }

        public AMQP.Exchange.DeleteOk exchangeDelete(String exchange, boolean ifUnused) throws IOException {
            return this.delegate.exchangeDelete(exchange, ifUnused);
        }

        public AMQP.Exchange.DeleteOk exchangeDelete(String exchange) throws IOException {
            return this.delegate.exchangeDelete(exchange);
        }

        public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey) throws IOException {
            return this.delegate.exchangeBind(destination, source, routingKey);
        }

        public AMQP.Exchange.BindOk exchangeBind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeBind(destination, source, routingKey, arguments);
        }

        public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey) throws IOException {
            return this.delegate.exchangeUnbind(destination, source, routingKey);
        }

        public AMQP.Exchange.UnbindOk exchangeUnbind(String destination, String source, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.exchangeUnbind(destination, source, routingKey, arguments);
        }

        public AMQP.Queue.DeclareOk queueDeclare() throws IOException {
            return this.delegate.queueDeclare();
        }

        public AMQP.Queue.DeclareOk queueDeclare(String queue, boolean durable, boolean exclusive, boolean autoDelete, Map<String, Object> arguments) throws IOException {
            return this.delegate.queueDeclare(queue, durable, exclusive, autoDelete, arguments);
        }

        public AMQP.Queue.DeclareOk queueDeclarePassive(String queue) throws IOException {
            return this.delegate.queueDeclarePassive(queue);
        }

        public AMQP.Queue.DeleteOk queueDelete(String queue) throws IOException {
            return this.delegate.queueDelete(queue);
        }

        public AMQP.Queue.DeleteOk queueDelete(String queue, boolean ifUnused, boolean ifEmpty) throws IOException {
            return this.delegate.queueDelete(queue, ifUnused, ifEmpty);
        }

        public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey) throws IOException {
            return this.delegate.queueBind(queue, exchange, routingKey);
        }

        public AMQP.Queue.BindOk queueBind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.queueBind(queue, exchange, routingKey, arguments);
        }

        public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey) throws IOException {
            return this.delegate.queueUnbind(queue, exchange, routingKey);
        }

        public AMQP.Queue.UnbindOk queueUnbind(String queue, String exchange, String routingKey, Map<String, Object> arguments) throws IOException {
            return this.delegate.queueUnbind(queue, exchange, routingKey, arguments);
        }

        public AMQP.Queue.PurgeOk queuePurge(String queue) throws IOException {
            return this.delegate.queuePurge(queue);
        }

        public GetResponse basicGet(String queue, boolean autoAck) throws IOException {
            return this.delegate.basicGet(queue, autoAck);
        }

        public void basicAck(long deliveryTag, boolean multiple) throws IOException {
            this.delegate.basicAck(deliveryTag, multiple);
        }

        public void basicNack(long deliveryTag, boolean multiple, boolean requeue) throws IOException {
            this.delegate.basicNack(deliveryTag, multiple, requeue);
        }

        public void basicReject(long deliveryTag, boolean requeue) throws IOException {
            this.delegate.basicReject(deliveryTag, requeue);
        }

        public String basicConsume(String queue, Consumer callback) throws IOException {
            return this.basicConsume(queue, false, callback);
        }

        public String basicConsume(String queue, boolean autoAck, Consumer callback) throws IOException {
            return this.basicConsume(queue, autoAck, "", callback);
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, Consumer callback) throws IOException {
            try {
                return this.basicConsume(queue, autoAck, consumerTag, false, true, null, callback);
            }
            catch (IOException e) {
                if (e.getCause() instanceof ShutdownSignalException && e.getCause().getMessage().contains("exclusive")) {
                    throw new IOException("Access is refused, as another Channel already has exclusive access to this queue", e);
                }
                throw e;
            }
        }

        public String basicConsume(String queue, boolean autoAck, String consumerTag, boolean noLocal, boolean exclusive, Map<String, Object> arguments, Consumer callback) throws IOException {
            return this.delegate.basicConsume(queue, autoAck, consumerTag, noLocal, exclusive, arguments, callback);
        }

        public void basicCancel(String consumerTag) throws IOException {
            this.delegate.basicCancel(consumerTag);
        }

        public AMQP.Basic.RecoverOk basicRecover() throws IOException {
            return this.delegate.basicRecover();
        }

        public AMQP.Basic.RecoverOk basicRecover(boolean requeue) throws IOException {
            return this.delegate.basicRecover(requeue);
        }

        @Deprecated
        public void basicRecoverAsync(boolean requeue) throws IOException {
            this.delegate.basicRecoverAsync(requeue);
        }

        public AMQP.Tx.SelectOk txSelect() throws IOException {
            return this.delegate.txSelect();
        }

        public AMQP.Tx.CommitOk txCommit() throws IOException {
            return this.delegate.txCommit();
        }

        public AMQP.Tx.RollbackOk txRollback() throws IOException {
            return this.delegate.txRollback();
        }

        public AMQP.Confirm.SelectOk confirmSelect() throws IOException {
            return this.delegate.confirmSelect();
        }

        public long getNextPublishSeqNo() {
            return this.delegate.getNextPublishSeqNo();
        }

        public boolean waitForConfirms() throws InterruptedException {
            return this.delegate.waitForConfirms();
        }

        public boolean waitForConfirms(long timeout) throws InterruptedException, TimeoutException {
            return this.delegate.waitForConfirms(timeout);
        }

        public void waitForConfirmsOrDie() throws IOException, InterruptedException {
            this.delegate.waitForConfirmsOrDie();
        }

        public void waitForConfirmsOrDie(long timeout) throws IOException, InterruptedException, TimeoutException {
            this.delegate.waitForConfirmsOrDie(timeout);
        }

        public void asyncRpc(Method method) throws IOException {
            this.delegate.asyncRpc(method);
        }

        public Command rpc(Method method) throws IOException {
            return this.delegate.rpc(method);
        }

        public void addShutdownListener(ShutdownListener listener) {
            this.delegate.addShutdownListener(listener);
        }

        public void removeShutdownListener(ShutdownListener listener) {
            this.delegate.removeShutdownListener(listener);
        }

        public ShutdownSignalException getCloseReason() {
            return this.delegate.getCloseReason();
        }

        public void notifyListeners() {
            this.delegate.notifyListeners();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }
    }

    private static class ExclusiveConnection
    implements Connection {
        private final Connection delegate;

        public ExclusiveConnection(Connection delegate) {
            this.delegate = delegate;
        }

        public Channel createChannel(boolean transactional) throws AmqpException {
            return new ExclusiveChannel(this.delegate.createChannel(transactional));
        }

        public void close() throws AmqpException {
            this.delegate.close();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }
    }

    private static class ExclusiveConnectionFactory
    implements ConnectionFactory {
        private final ConnectionFactory delegate;

        public ExclusiveConnectionFactory(ConnectionFactory delegate) {
            this.delegate = delegate;
        }

        public ConnectionFactory getDelegate() {
            return this.delegate;
        }

        public Connection createConnection() throws AmqpException {
            return new ExclusiveConnection(this.delegate.createConnection());
        }

        public String getHost() {
            return this.delegate.getHost();
        }

        public int getPort() {
            return this.delegate.getPort();
        }

        public String getVirtualHost() {
            return this.delegate.getVirtualHost();
        }

        public void addConnectionListener(ConnectionListener listener) {
            this.delegate.addConnectionListener(listener);
        }
    }
}

