/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.amqp.spring;

import org.axonframework.eventhandling.amqp.spring.DefaultRabbitMqStrategy;
import org.axonframework.eventhandling.amqp.spring.LegacyRabbitMqStrategy;
import org.axonframework.eventhandling.amqp.spring.RabbitMqStrategy;
import org.axonframework.eventhandling.amqp.spring.SpringAMQPConsumerConfiguration;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ListenerContainerFactory
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private ConnectionFactory connectionFactory;
    private static final RabbitMqStrategy rabbitMqStrategy;

    public SimpleMessageListenerContainer createContainer(SpringAMQPConsumerConfiguration config) {
        SimpleMessageListenerContainer newContainer = rabbitMqStrategy.createContainer();
        newContainer.setConnectionFactory(this.connectionFactory);
        if (config.getTransactionManager() != null) {
            newContainer.setChannelTransacted(true);
            newContainer.setTransactionManager(config.getTransactionManager());
        }
        if (config.getErrorHandler() != null) {
            newContainer.setErrorHandler(config.getErrorHandler());
        }
        if (config.getPrefetchCount() != null) {
            newContainer.setPrefetchCount(config.getPrefetchCount().intValue());
        }
        if (config.getTxSize() != null) {
            newContainer.setTxSize(config.getTxSize().intValue());
        }
        if (config.getAdviceChain() != null) {
            newContainer.setAdviceChain(config.getAdviceChain());
        }
        if (config.getRecoveryInterval() != null) {
            newContainer.setRecoveryInterval(config.getRecoveryInterval().longValue());
        }
        if (config.getConcurrentConsumers() != null) {
            newContainer.setConcurrentConsumers(config.getConcurrentConsumers().intValue());
        }
        if (config.getReceiveTimeout() != null) {
            newContainer.setReceiveTimeout(config.getReceiveTimeout().longValue());
        }
        if (config.getShutdownTimeout() != null) {
            newContainer.setShutdownTimeout(config.getShutdownTimeout().longValue());
        }
        if (config.getTaskExecutor() != null) {
            newContainer.setTaskExecutor(config.getTaskExecutor());
        }
        if (config.getTransactionAttribute() != null) {
            newContainer.setTransactionAttribute(config.getTransactionAttribute());
        }
        if (config.getMessagePropertiesConverter() != null) {
            newContainer.setMessagePropertiesConverter(config.getMessagePropertiesConverter());
        }
        if (config.getAcknowledgeMode() != null) {
            newContainer.setAcknowledgeMode(config.getAcknowledgeMode());
        }
        if (config.getExclusive() != null) {
            rabbitMqStrategy.setExclusive(newContainer, config.getExclusive());
        }
        newContainer.afterPropertiesSet();
        return newContainer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.connectionFactory == null) {
            this.connectionFactory = (ConnectionFactory)this.applicationContext.getBean(ConnectionFactory.class);
        }
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    static {
        boolean methodExists;
        try {
            SimpleMessageListenerContainer.class.getMethod("setExclusive", Boolean.TYPE);
            methodExists = true;
        }
        catch (NoSuchMethodException e) {
            methodExists = false;
        }
        rabbitMqStrategy = methodExists ? new DefaultRabbitMqStrategy() : new LegacyRabbitMqStrategy();
    }
}

