/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.amqp.spring;

import java.util.HashMap;
import java.util.Map;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.amqp.AMQPConsumerConfiguration;
import org.axonframework.eventhandling.amqp.AMQPMessageConverter;
import org.axonframework.eventhandling.amqp.spring.ClusterMessageListener;
import org.axonframework.eventhandling.amqp.spring.ListenerContainerFactory;
import org.axonframework.eventhandling.amqp.spring.SpringAMQPConsumerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.SmartLifecycle;

public class ListenerContainerLifecycleManager
extends ListenerContainerFactory
implements SmartLifecycle,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(ListenerContainerLifecycleManager.class);
    private final Map<String, SimpleMessageListenerContainer> containerPerQueue = new HashMap<String, SimpleMessageListenerContainer>();
    private boolean started = false;
    private SpringAMQPConsumerConfiguration defaultConfiguration;
    private int phase = Integer.MAX_VALUE;

    public synchronized void registerCluster(Cluster cluster, AMQPConsumerConfiguration config, AMQPMessageConverter messageConverter) {
        SpringAMQPConsumerConfiguration amqpConfig = SpringAMQPConsumerConfiguration.wrap(config);
        amqpConfig.setDefaults(this.defaultConfiguration);
        String queueName = amqpConfig.getQueueName();
        if (queueName == null) {
            throw new AxonConfigurationException("The Cluster does not define a Queue Name, nor is there a default Queue Name configured in the ListenerContainerLifeCycleManager");
        }
        if (this.containerPerQueue.containsKey(queueName)) {
            ClusterMessageListener existingListener = (ClusterMessageListener)this.containerPerQueue.get(queueName).getMessageListener();
            existingListener.addCluster(cluster);
            if (this.started && logger.isWarnEnabled()) {
                logger.warn("A cluster was configured on queue [{}], while the Container for that queue was already processing events. This may lead to Events not being published to all Clusters", (Object)queueName);
            }
        } else {
            SimpleMessageListenerContainer newContainer = this.createContainer(amqpConfig);
            newContainer.setQueueNames(new String[]{queueName});
            newContainer.setMessageListener((Object)new ClusterMessageListener(cluster, messageConverter));
            this.containerPerQueue.put(queueName, newContainer);
            if (this.started) {
                newContainer.start();
            }
        }
    }

    public boolean isAutoStartup() {
        return true;
    }

    public synchronized void stop(Runnable callback) {
        for (SimpleMessageListenerContainer container : this.containerPerQueue.values()) {
            container.stop();
        }
        this.started = false;
        callback.run();
    }

    public synchronized void start() {
        for (SimpleMessageListenerContainer container : this.containerPerQueue.values()) {
            if (container.isRunning()) continue;
            container.start();
        }
        this.started = true;
    }

    public synchronized void stop() {
        for (SimpleMessageListenerContainer container : this.containerPerQueue.values()) {
            if (!container.isRunning()) continue;
            container.stop();
        }
        this.started = false;
    }

    public synchronized boolean isRunning() {
        for (SimpleMessageListenerContainer container : this.containerPerQueue.values()) {
            if (!container.isRunning()) continue;
            return true;
        }
        return false;
    }

    public synchronized void destroy() throws Exception {
        for (SimpleMessageListenerContainer container : this.containerPerQueue.values()) {
            container.destroy();
        }
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public synchronized void setDefaultConfiguration(SpringAMQPConsumerConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }
}

