/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.amqp.spring;

import java.util.Arrays;
import java.util.concurrent.Executor;
import org.aopalliance.aop.Advice;
import org.axonframework.eventhandling.amqp.AMQPConsumerConfiguration;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.rabbit.support.MessagePropertiesConverter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.ErrorHandler;

public class SpringAMQPConsumerConfiguration
implements AMQPConsumerConfiguration {
    private PlatformTransactionManager transactionManager;
    private ErrorHandler errorHandler;
    private Integer txSize;
    private Integer prefetchCount;
    private Advice[] adviceChain;
    private Long recoveryInterval;
    private Integer concurrentConsumers;
    private Long receiveTimeout;
    private Long shutdownTimeout;
    private Executor taskExecutor;
    private TransactionAttribute transactionAttribute;
    private MessagePropertiesConverter messagePropertiesConverter;
    private AcknowledgeMode acknowledgeMode;
    private Boolean exclusive;
    private String queueName;
    private SpringAMQPConsumerConfiguration defaults;

    public static SpringAMQPConsumerConfiguration wrap(AMQPConsumerConfiguration configuration) {
        if (configuration instanceof SpringAMQPConsumerConfiguration) {
            return (SpringAMQPConsumerConfiguration)configuration;
        }
        SpringAMQPConsumerConfiguration springConfig = new SpringAMQPConsumerConfiguration();
        springConfig.setQueueName(configuration.getQueueName());
        springConfig.setExclusive(configuration.getExclusive());
        springConfig.setPrefetchCount(configuration.getPrefetchCount());
        return springConfig;
    }

    public void setDefaults(SpringAMQPConsumerConfiguration defaults) {
        this.defaults = defaults;
    }

    @Override
    public String getQueueName() {
        return this.queueName != null ? this.queueName : (this.defaults == null ? null : this.defaults.getQueueName());
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager != null ? this.transactionManager : (this.defaults == null ? null : this.defaults.getTransactionManager());
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler != null ? this.errorHandler : (this.defaults == null ? null : this.defaults.getErrorHandler());
    }

    public Integer getTxSize() {
        return this.txSize != null ? this.txSize : (this.defaults == null ? null : this.defaults.getTxSize());
    }

    @Override
    public Integer getPrefetchCount() {
        return this.prefetchCount != null ? this.prefetchCount : (this.defaults == null ? null : this.defaults.getPrefetchCount());
    }

    public Advice[] getAdviceChain() {
        return this.adviceChain != null ? this.adviceChain : (this.defaults == null ? null : this.defaults.getAdviceChain());
    }

    public Long getRecoveryInterval() {
        return this.recoveryInterval != null ? this.recoveryInterval : (this.defaults == null ? null : this.defaults.getRecoveryInterval());
    }

    public Integer getConcurrentConsumers() {
        return this.concurrentConsumers != null ? this.concurrentConsumers : (this.defaults == null ? null : this.defaults.getConcurrentConsumers());
    }

    public Long getReceiveTimeout() {
        return this.receiveTimeout != null ? this.receiveTimeout : (this.defaults == null ? null : this.defaults.getReceiveTimeout());
    }

    public Long getShutdownTimeout() {
        return this.shutdownTimeout != null ? this.shutdownTimeout : (this.defaults == null ? null : this.defaults.getShutdownTimeout());
    }

    public Executor getTaskExecutor() {
        return this.taskExecutor != null ? this.taskExecutor : (this.defaults == null ? null : this.defaults.getTaskExecutor());
    }

    public TransactionAttribute getTransactionAttribute() {
        return this.transactionAttribute != null ? this.transactionAttribute : (this.defaults == null ? null : this.defaults.getTransactionAttribute());
    }

    public MessagePropertiesConverter getMessagePropertiesConverter() {
        return this.messagePropertiesConverter != null ? this.messagePropertiesConverter : (this.defaults == null ? null : this.defaults.getMessagePropertiesConverter());
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode != null ? this.acknowledgeMode : (this.defaults == null ? null : this.defaults.getAcknowledgeMode());
    }

    @Override
    public Boolean getExclusive() {
        return this.exclusive != null ? this.exclusive : (this.defaults == null ? null : this.defaults.getExclusive());
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setTxSize(Integer txSize) {
        this.txSize = txSize;
    }

    public void setPrefetchCount(Integer prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public void setAdviceChain(Advice[] adviceChain) {
        this.adviceChain = Arrays.copyOf(adviceChain, adviceChain.length);
    }

    public void setRecoveryInterval(Long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public void setConcurrentConsumers(Integer concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public void setShutdownTimeout(Long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setTransactionAttribute(TransactionAttribute transactionAttribute) {
        this.transactionAttribute = transactionAttribute;
    }

    public void setMessagePropertiesConverter(MessagePropertiesConverter messagePropertiesConverter) {
        this.messagePropertiesConverter = messagePropertiesConverter;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public void setExclusive(Boolean exclusive) {
        this.exclusive = exclusive;
    }
}

