/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.amqp.eventhandling;

import com.rabbitmq.client.AMQP;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.axonframework.amqp.eventhandling.AMQPMessage;
import org.axonframework.amqp.eventhandling.AMQPMessageConverter;
import org.axonframework.amqp.eventhandling.PackageRoutingKeyResolver;
import org.axonframework.amqp.eventhandling.RoutingKeyResolver;
import org.axonframework.common.Assert;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.eventsourcing.GenericDomainEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.MessageSerializer;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;

public class DefaultAMQPMessageConverter
implements AMQPMessageConverter {
    private final Serializer serializer;
    private final RoutingKeyResolver routingKeyResolver;
    private final boolean durable;

    public DefaultAMQPMessageConverter(Serializer serializer) {
        this(serializer, new PackageRoutingKeyResolver(), true);
    }

    public DefaultAMQPMessageConverter(Serializer serializer, RoutingKeyResolver routingKeyResolver, boolean durable) {
        Assert.notNull((Object)serializer, () -> "Serializer may not be null");
        Assert.notNull((Object)routingKeyResolver, () -> "RoutingKeyResolver may not be null");
        this.serializer = serializer;
        this.routingKeyResolver = routingKeyResolver;
        this.durable = durable;
    }

    @Override
    public AMQPMessage createAMQPMessage(EventMessage<?> eventMessage) {
        SerializedObject serializedObject = MessageSerializer.serializePayload(eventMessage, (Serializer)this.serializer, byte[].class);
        String routingKey = this.routingKeyResolver.resolveRoutingKey(eventMessage);
        AMQP.BasicProperties.Builder properties = new AMQP.BasicProperties.Builder();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        eventMessage.getMetaData().forEach((k, v) -> headers.put("axon-metadata-" + k, v));
        headers.put("axon-message-id", eventMessage.getIdentifier());
        headers.put("axon-message-type", serializedObject.getType().getName());
        headers.put("axon-message-revision", serializedObject.getType().getRevision());
        headers.put("axon-message-timestamp", eventMessage.getTimestamp().toString());
        if (eventMessage instanceof DomainEventMessage) {
            headers.put("axon-message-aggregate-id", ((DomainEventMessage)eventMessage).getAggregateIdentifier());
            headers.put("axon-message-aggregate-seq", ((DomainEventMessage)eventMessage).getSequenceNumber());
            headers.put("axon-message-aggregate-type", ((DomainEventMessage)eventMessage).getType());
        }
        properties.headers(headers);
        if (this.durable) {
            properties.deliveryMode(Integer.valueOf(2));
        }
        return new AMQPMessage((byte[])serializedObject.getData(), routingKey, properties.build(), false, false);
    }

    @Override
    public Optional<EventMessage<?>> readAMQPMessage(byte[] messageBody, Map<String, Object> headers) {
        if (!headers.keySet().containsAll(Arrays.asList("axon-message-id", "axon-message-type"))) {
            return Optional.empty();
        }
        HashMap metaData = new HashMap();
        headers.forEach((k, v) -> {
            if (k.startsWith("axon-metadata-")) {
                metaData.put(k.substring("axon-metadata-".length()), v);
            }
        });
        SimpleSerializedObject serializedMessage = new SimpleSerializedObject((Object)messageBody, byte[].class, Objects.toString(headers.get("axon-message-type")), Objects.toString(headers.get("axon-message-revision"), null));
        SerializedMessage message = new SerializedMessage(Objects.toString(headers.get("axon-message-id")), new LazyDeserializingObject((SerializedObject)serializedMessage, this.serializer), new LazyDeserializingObject((Object)MetaData.from(metaData)));
        String timestamp = Objects.toString(headers.get("axon-message-timestamp"));
        if (headers.containsKey("axon-message-aggregate-id")) {
            return Optional.of(new GenericDomainEventMessage(Objects.toString(headers.get("axon-message-aggregate-type")), Objects.toString(headers.get("axon-message-aggregate-id")), ((Long)headers.get("axon-message-aggregate-seq")).longValue(), (Message)message, () -> Instant.parse(timestamp)));
        }
        return Optional.of(new GenericEventMessage((Message)message, () -> Instant.parse(timestamp)));
    }
}

