/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.amqp.eventhandling.legacy;

import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;

public enum EventMessageType {
    DOMAIN_EVENT_MESSAGE(3, DomainEventMessage.class),
    EVENT_MESSAGE(1, EventMessage.class);

    private final byte typeByte;
    private final Class<? extends EventMessage> messageClass;

    public static EventMessageType forMessage(EventMessage message) {
        for (EventMessageType type : EventMessageType.values()) {
            if (!type.messageClass.isInstance(message)) continue;
            return type;
        }
        return EVENT_MESSAGE;
    }

    public static EventMessageType fromTypeByte(byte typeByte) {
        for (EventMessageType type : EventMessageType.values()) {
            if (type.typeByte != typeByte) continue;
            return type;
        }
        return null;
    }

    private EventMessageType(byte typeByte, Class<? extends EventMessage> messageClass) {
        this.typeByte = typeByte;
        this.messageClass = messageClass;
    }

    public byte getTypeByte() {
        return this.typeByte;
    }
}

