/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.amqp.eventhandling.spring;

import com.rabbitmq.client.Channel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.axonframework.amqp.eventhandling.AMQPMessageConverter;
import org.axonframework.amqp.eventhandling.DefaultAMQPMessageConverter;
import org.axonframework.common.Registration;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.UnknownSerializedTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;

public class SpringAMQPMessageSource
implements ChannelAwareMessageListener,
SubscribableMessageSource<EventMessage<?>> {
    private static final Logger logger = LoggerFactory.getLogger(SpringAMQPMessageSource.class);
    private final List<Consumer<List<? extends EventMessage<?>>>> eventProcessors = new CopyOnWriteArrayList();
    private final AMQPMessageConverter messageConverter;

    public SpringAMQPMessageSource(Serializer serializer) {
        this(new DefaultAMQPMessageConverter(serializer));
    }

    public SpringAMQPMessageSource(AMQPMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public Registration subscribe(Consumer<List<? extends EventMessage<?>>> messageProcessor) {
        this.eventProcessors.add(messageProcessor);
        return () -> this.eventProcessors.remove(messageProcessor);
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        if (!this.eventProcessors.isEmpty()) {
            try {
                EventMessage event = this.messageConverter.readAMQPMessage(message.getBody(), message.getMessageProperties().getHeaders()).orElse(null);
                if (event != null) {
                    this.eventProcessors.forEach(ep -> ep.accept(Collections.singletonList(event)));
                }
            }
            catch (UnknownSerializedTypeException e) {
                logger.warn("Unable to deserialize an incoming message. Ignoring it. {}", (Object)e.toString());
            }
        }
    }
}

