/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.amqp.eventhandling.legacy;

import java.io.DataOutput;
import java.io.IOException;
import org.axonframework.amqp.eventhandling.legacy.EventMessageType;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.DomainEventMessage;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.MessageSerializer;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

public class EventMessageWriter {
    private final MessageSerializer serializer;
    private final DataOutput out;

    public EventMessageWriter(DataOutput output, Serializer serializer) {
        this.out = output;
        this.serializer = new MessageSerializer(serializer);
    }

    public void writeEventMessage(EventMessage eventMessage) throws IOException {
        if (DomainEventMessage.class.isInstance(eventMessage)) {
            this.out.writeByte(EventMessageType.DOMAIN_EVENT_MESSAGE.getTypeByte());
        } else {
            this.out.writeByte(EventMessageType.EVENT_MESSAGE.getTypeByte());
        }
        this.out.writeUTF(eventMessage.getIdentifier());
        this.out.writeUTF(eventMessage.getTimestamp().toString());
        if (eventMessage instanceof DomainEventMessage) {
            DomainEventMessage domainEventMessage = (DomainEventMessage)eventMessage;
            this.out.writeUTF(domainEventMessage.getAggregateIdentifier());
            this.out.writeLong(domainEventMessage.getSequenceNumber());
        }
        SerializedObject serializedPayload = this.serializer.serializePayload((Message)eventMessage, byte[].class);
        SerializedObject serializedMetaData = this.serializer.serializeMetaData((Message)eventMessage, byte[].class);
        this.out.writeUTF(serializedPayload.getType().getName());
        String revision = serializedPayload.getType().getRevision();
        this.out.writeUTF(revision == null ? "" : revision);
        this.out.writeInt(((byte[])serializedPayload.getData()).length);
        this.out.write((byte[])serializedPayload.getData());
        this.out.writeInt(((byte[])serializedMetaData.getData()).length);
        this.out.write((byte[])serializedMetaData.getData());
    }
}

