/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.config;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.common.Assert;
import org.axonframework.config.AggregateConfiguration;
import org.axonframework.config.Configuration;
import org.axonframework.config.SagaConfiguration;
import org.axonframework.messaging.ScopeAware;
import org.axonframework.messaging.ScopeAwareProvider;
import org.axonframework.messaging.ScopeDescriptor;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.saga.AbstractSagaManager;

public class ConfigurationScopeAwareProvider
implements ScopeAwareProvider {
    private final Configuration configuration;
    private List<ScopeAware> scopeAwareComponents;

    public ConfigurationScopeAwareProvider(Configuration configuration) {
        this.configuration = (Configuration)Assert.nonNull((Object)configuration, () -> "configuration may not be null");
    }

    public Stream<ScopeAware> provideScopeAwareStream(ScopeDescriptor scopeDescriptor) {
        if (this.scopeAwareComponents == null) {
            this.scopeAwareComponents = this.retrieveScopeAwareComponents();
        }
        return this.scopeAwareComponents.stream();
    }

    private List<ScopeAware> retrieveScopeAwareComponents() {
        ArrayList<ScopeAware> components = new ArrayList<ScopeAware>();
        components.addAll(this.retrieveAggregateRepositories());
        components.addAll(this.retrieveSagaManagers());
        return components;
    }

    private List<Repository> retrieveAggregateRepositories() {
        return this.configuration.findModules(AggregateConfiguration.class).stream().map(AggregateConfiguration::repository).collect(Collectors.toList());
    }

    private List<AbstractSagaManager> retrieveSagaManagers() {
        return this.configuration.eventProcessingConfiguration().sagaConfigurations().stream().map(SagaConfiguration::manager).collect(Collectors.toList());
    }
}

