/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.tracing.NoOpSpanFactory;
import org.axonframework.tracing.Span;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.SpanScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotter
implements Snapshotter {
    private static final String SCHEDULED_SNAPSHOT_SET = "SCHEDULED_SNAPSHOT_SET";
    private static final Logger logger = LoggerFactory.getLogger(AbstractSnapshotter.class);
    private final EventStore eventStore;
    private final Executor executor;
    private final TransactionManager transactionManager;
    private final Set<AggregateTypeId> snapshotsInProgress = ConcurrentHashMap.newKeySet();
    private final SpanFactory spanFactory;

    protected AbstractSnapshotter(Builder builder) {
        builder.validate();
        this.eventStore = builder.eventStore;
        this.executor = builder.executor;
        this.transactionManager = builder.transactionManager;
        this.spanFactory = builder.builderSpanFactory;
    }

    @Override
    public void scheduleSnapshot(@Nonnull Class<?> aggregateType, @Nonnull String aggregateIdentifier) {
        if (CurrentUnitOfWork.isStarted() && CurrentUnitOfWork.get().phase().isBefore(UnitOfWork.Phase.COMMIT)) {
            CurrentUnitOfWork.get().afterCommit(u -> this.doScheduleSnapshot(aggregateType, aggregateIdentifier));
        } else {
            this.doScheduleSnapshot(aggregateType, aggregateIdentifier);
        }
    }

    private void doScheduleSnapshot(Class<?> aggregateType, String aggregateIdentifier) {
        Set scheduledSnapshotMap;
        AggregateTypeId typeAndId = new AggregateTypeId(aggregateType, aggregateIdentifier);
        if (CurrentUnitOfWork.isStarted() && !(scheduledSnapshotMap = (Set)CurrentUnitOfWork.get().root().getOrComputeResource(SCHEDULED_SNAPSHOT_SET, key -> new HashSet())).add(typeAndId)) {
            return;
        }
        if (this.snapshotsInProgress.add(typeAndId)) {
            Span span = this.spanFactory.createRootTrace(() -> this.traceName(aggregateType)).start();
            try (SpanScope unused = span.makeCurrent();){
                Span internalSpan = this.spanFactory.createInternalSpan(() -> this.getInnerTraceName(aggregateType, aggregateIdentifier));
                this.executor.execute(this.silently(internalSpan.wrapRunnable(() -> this.transactionManager.executeInTransaction(this.createSnapshotterTask(aggregateType, aggregateIdentifier)))).andFinally(() -> this.snapshotsInProgress.remove(typeAndId)));
            }
            catch (Exception e) {
                this.snapshotsInProgress.remove(typeAndId);
                span.recordException((Throwable)e);
                throw e;
            }
            finally {
                span.end();
            }
        }
    }

    private String getInnerTraceName(Class<?> aggregateType, String aggregateIdentifier) {
        return String.format("%s.createSnapshot(%s,%s)", this.getClass().getSimpleName(), aggregateType.getSimpleName(), aggregateIdentifier);
    }

    private String traceName(Class<?> aggregateType) {
        return String.format("%s.createSnapshot(%s)", this.getClass().getSimpleName(), aggregateType.getSimpleName());
    }

    private SilentTask silently(Runnable r) {
        return new SilentTask(r);
    }

    protected Runnable createSnapshotterTask(Class<?> aggregateType, String aggregateIdentifier) {
        return new CreateSnapshotTask(aggregateType, aggregateIdentifier);
    }

    protected abstract DomainEventMessage createSnapshot(Class<?> var1, String var2, DomainEventStream var3);

    protected EventStore getEventStore() {
        return this.eventStore;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    private final class CreateSnapshotTask
    implements Runnable {
        private final Class<?> aggregateType;
        private final String identifier;

        private CreateSnapshotTask(Class<?> aggregateType, String identifier) {
            this.aggregateType = aggregateType;
            this.identifier = identifier;
        }

        @Override
        public void run() {
            DomainEventStream eventStream = AbstractSnapshotter.this.eventStore.readEvents(this.identifier);
            long firstEventSequenceNumber = eventStream.peek().getSequenceNumber();
            DomainEventMessage snapshotEvent = AbstractSnapshotter.this.createSnapshot(this.aggregateType, this.identifier, eventStream);
            if (snapshotEvent != null && snapshotEvent.getSequenceNumber() > firstEventSequenceNumber) {
                AbstractSnapshotter.this.eventStore.storeSnapshot(snapshotEvent);
            }
        }
    }

    private static class RunnableAndFinally
    implements Runnable {
        private final Runnable first;
        private final Runnable then;

        public RunnableAndFinally(Runnable first, Runnable then) {
            this.first = first;
            this.then = then;
        }

        @Override
        public void run() {
            try {
                this.first.run();
            }
            finally {
                this.then.run();
            }
        }
    }

    private static class SilentTask
    implements Runnable {
        private final Runnable snapshotterTask;

        private SilentTask(Runnable snapshotterTask) {
            this.snapshotterTask = snapshotterTask;
        }

        @Override
        public void run() {
            try {
                this.snapshotterTask.run();
            }
            catch (ConcurrencyException e) {
                logger.info("An up-to-date snapshot entry already exists, ignoring this attempt.");
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("An attempt to create and store a snapshot resulted in an exception:", (Throwable)e);
                }
                logger.warn("An attempt to create and store a snapshot resulted in an exception. Exception summary: {}", (Object)e.getMessage());
            }
        }

        public Runnable andFinally(Runnable r) {
            return new RunnableAndFinally(this, r);
        }
    }

    public static abstract class Builder {
        private EventStore eventStore;
        private Executor executor = DirectExecutor.INSTANCE;
        private TransactionManager transactionManager = NoTransactionManager.INSTANCE;
        private SpanFactory builderSpanFactory = NoOpSpanFactory.INSTANCE;

        public Builder eventStore(EventStore eventStore) {
            BuilderUtils.assertNonNull((Object)eventStore, (String)"EventStore may not be null");
            this.eventStore = eventStore;
            return this;
        }

        public Builder executor(Executor executor) {
            BuilderUtils.assertNonNull((Object)executor, (String)"Executor may not be null");
            this.executor = executor;
            return this;
        }

        public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
            BuilderUtils.assertNonNull((Object)spanFactory, (String)"SpanFactory may not be null");
            this.builderSpanFactory = spanFactory;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull((Object)transactionManager, (String)"TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            BuilderUtils.assertNonNull((Object)this.eventStore, (String)"The EventStore is a hard requirement and should be provided");
        }
    }

    private static class AggregateTypeId {
        private final Class<?> aggregateType;
        private final String aggregateIdentifier;

        private AggregateTypeId(Class<?> aggregateType, String aggregateIdentifier) {
            this.aggregateType = aggregateType;
            this.aggregateIdentifier = aggregateIdentifier;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AggregateTypeId that = (AggregateTypeId)o;
            return Objects.equals(this.aggregateType, that.aggregateType) && Objects.equals(this.aggregateIdentifier, that.aggregateIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.aggregateType, this.aggregateIdentifier);
        }
    }
}

