/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.time.Clock;
import org.axonframework.eventsourcing.AbstractSnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.Snapshotter;

public class AggregateLoadTimeSnapshotTriggerDefinition
implements SnapshotTriggerDefinition {
    private final Snapshotter snapshotter;
    private final long loadTimeMillisThreshold;
    public static Clock clock = Clock.systemUTC();

    public AggregateLoadTimeSnapshotTriggerDefinition(Snapshotter snapshotter, long loadTimeMillisThreshold) {
        this.snapshotter = snapshotter;
        this.loadTimeMillisThreshold = loadTimeMillisThreshold;
    }

    @Override
    public SnapshotTrigger prepareTrigger(@Nonnull Class<?> aggregateType) {
        return new AggregateLoadTimeSnapshotTrigger(this.snapshotter, aggregateType, this.loadTimeMillisThreshold);
    }

    @Override
    public SnapshotTrigger reconfigure(@Nonnull Class<?> aggregateType, @Nonnull SnapshotTrigger trigger) {
        if (trigger instanceof AggregateLoadTimeSnapshotTrigger) {
            ((AggregateLoadTimeSnapshotTrigger)trigger).setSnapshotter(this.snapshotter);
            return trigger;
        }
        return new AggregateLoadTimeSnapshotTrigger(this.snapshotter, aggregateType, this.loadTimeMillisThreshold);
    }

    private static class AggregateLoadTimeSnapshotTrigger
    extends AbstractSnapshotTrigger {
        private final long loadTimeMillisThreshold;
        private long startTime = clock.instant().toEpochMilli();

        public AggregateLoadTimeSnapshotTrigger(Snapshotter snapshotter, Class<?> aggregateType, long loadTimeMillisThreshold) {
            super(snapshotter, aggregateType);
            this.loadTimeMillisThreshold = loadTimeMillisThreshold;
        }

        @Override
        public boolean exceedsThreshold() {
            return clock.instant().toEpochMilli() - this.startTime > this.loadTimeMillisThreshold;
        }

        @Override
        public void reset() {
            this.startTime = clock.instant().toEpochMilli();
        }
    }
}

