/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import jakarta.annotation.Nonnull;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;

public class FilteringEventStorageEngine
implements EventStorageEngine {
    private final EventStorageEngine delegate;
    private final Predicate<? super EventMessage<?>> filter;

    public FilteringEventStorageEngine(EventStorageEngine delegate, Predicate<? super EventMessage<?>> filter) {
        this.delegate = delegate;
        this.filter = filter;
    }

    @Override
    public void appendEvents(EventMessage<?> ... events) {
        this.delegate.appendEvents(Arrays.stream(events).filter(this.filter).collect(Collectors.toList()));
    }

    @Override
    public void appendEvents(@Nonnull List<? extends EventMessage<?>> events) {
        this.delegate.appendEvents(events.stream().filter(this.filter).collect(Collectors.toList()));
    }

    @Override
    public void storeSnapshot(@Nonnull DomainEventMessage<?> snapshot) {
        this.delegate.storeSnapshot(snapshot);
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        return this.delegate.readEvents(trackingToken, mayBlock);
    }

    @Override
    public DomainEventStream readEvents(@Nonnull String aggregateIdentifier) {
        return this.delegate.readEvents(aggregateIdentifier);
    }

    @Override
    public DomainEventStream readEvents(@Nonnull String aggregateIdentifier, long firstSequenceNumber) {
        return this.delegate.readEvents(aggregateIdentifier, firstSequenceNumber);
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(@Nonnull String aggregateIdentifier) {
        return this.delegate.readSnapshot(aggregateIdentifier);
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(@Nonnull String aggregateIdentifier) {
        return this.delegate.lastSequenceNumberFor(aggregateIdentifier);
    }

    @Override
    public TrackingToken createTailToken() {
        return this.delegate.createTailToken();
    }

    @Override
    public TrackingToken createHeadToken() {
        return this.delegate.createHeadToken();
    }

    @Override
    public TrackingToken createTokenAt(@Nonnull Instant dateTime) {
        return this.delegate.createTokenAt(dateTime);
    }
}

