/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.axonframework.common.jdbc.Oracle11Utils;
import org.axonframework.eventsourcing.eventstore.jdbc.AbstractEventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;

public class Oracle11EventTableFactory
extends AbstractEventTableFactory {
    @Override
    public PreparedStatement createDomainEventTable(Connection connection, EventSchema schema) throws SQLException {
        String sql = "CREATE TABLE " + schema.domainEventTable() + " (\n" + schema.globalIndexColumn() + " NUMBER(19) NOT NULL,\n" + schema.aggregateIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.sequenceNumberColumn() + " NUMBER(19) NOT NULL,\n" + schema.typeColumn() + " VARCHAR(255),\n" + schema.eventIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.metaDataColumn() + " " + this.payloadType() + ",\n" + schema.payloadColumn() + " " + this.payloadType() + " NOT NULL,\n" + schema.payloadRevisionColumn() + " VARCHAR(255),\n" + schema.payloadTypeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.timestampColumn() + " VARCHAR(255) NOT NULL,\nPRIMARY KEY (" + schema.globalIndexColumn() + "),\nUNIQUE (" + schema.aggregateIdentifierColumn() + ", " + schema.sequenceNumberColumn() + "),\nUNIQUE (" + schema.eventIdentifierColumn() + ")\n)";
        connection.prepareStatement(sql).execute();
        Oracle11Utils.simulateAutoIncrement((Connection)connection, (String)schema.domainEventTable(), (String)schema.globalIndexColumn());
        return Oracle11Utils.createNullStatement((Connection)connection);
    }

    @Override
    public PreparedStatement createSnapshotEventTable(Connection connection, EventSchema schema) throws SQLException {
        String sql = "CREATE TABLE " + schema.snapshotTable() + " (\n" + schema.aggregateIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.sequenceNumberColumn() + " NUMBER(19) NOT NULL,\n" + schema.typeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.eventIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.metaDataColumn() + " " + this.payloadType() + ",\n" + schema.payloadColumn() + " " + this.payloadType() + " NOT NULL,\n" + schema.payloadRevisionColumn() + " VARCHAR(255),\n" + schema.payloadTypeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.timestampColumn() + " VARCHAR(255) NOT NULL,\nPRIMARY KEY (" + schema.aggregateIdentifierColumn() + ", " + schema.sequenceNumberColumn() + "),\nUNIQUE (" + schema.eventIdentifierColumn() + ")\n)";
        return connection.prepareStatement(sql);
    }

    @Override
    protected String idColumnType() {
        return "";
    }

    @Override
    protected String payloadType() {
        return "BLOB";
    }
}

