/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;

public class ConcatenatingDomainEventStream
implements DomainEventStream {
    private final LinkedList<DomainEventStream> streams;
    private final List<DomainEventStream> consumedStreams;
    private Long lastSeenSequenceNumber;

    public ConcatenatingDomainEventStream(DomainEventStream ... streams) {
        this(Arrays.asList(streams));
    }

    public ConcatenatingDomainEventStream(Collection<DomainEventStream> streams) {
        this.streams = new LinkedList<DomainEventStream>(streams);
        this.consumedStreams = new ArrayList<DomainEventStream>();
    }

    @Override
    public DomainEventMessage<?> peek() {
        if (!this.hasNext()) {
            return null;
        }
        return this.streams.peekFirst().peek();
    }

    @Override
    public boolean hasNext() {
        if (!this.streams.isEmpty() && this.streams.peekFirst().hasNext()) {
            return true;
        }
        while (!this.streams.isEmpty() && !this.streams.peekFirst().hasNext()) {
            this.consumedStreams.add(this.streams.pollFirst());
        }
        if (this.streams.isEmpty()) {
            return false;
        }
        DomainEventMessage<?> peeked = this.streams.peekFirst().peek();
        while (this.lastSeenSequenceNumber != null && peeked.getSequenceNumber() <= this.lastSeenSequenceNumber) {
            while (!this.streams.peekFirst().hasNext()) {
                this.consumedStreams.add(this.streams.pollFirst());
                if (!this.streams.isEmpty()) continue;
                return false;
            }
            this.streams.peekFirst().next();
            if (!this.streams.peekFirst().hasNext()) continue;
            peeked = this.streams.peekFirst().peek();
        }
        return !this.streams.isEmpty() && this.streams.peekFirst().hasNext();
    }

    @Override
    public DomainEventMessage<?> next() {
        if (!this.hasNext()) {
            return null;
        }
        DomainEventMessage<?> next = this.streams.peekFirst().next();
        this.lastSeenSequenceNumber = next.getSequenceNumber();
        return next;
    }

    @Override
    public Long getLastSequenceNumber() {
        return Stream.concat(this.consumedStreams.stream(), this.streams.stream()).map(DomainEventStream::getLastSequenceNumber).filter((? super T x) -> !Objects.isNull(x)).reduce(Math::max).orElse(null);
    }
}

