/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.internal.util.collections.Sets;

class AbstractAggregateFactoryTest {
    AbstractAggregateFactoryTest() {
    }

    @Test
    void polymorphicFactoryConstructorBuildsAnticipatedAggregateModel() {
        Set subTypes = Sets.newSet((Object[])new Class[]{LeafOneAggregate.class, LeafTwoAggregate.class});
        AggregateModel expectedAggregateModel = AnnotatedAggregateMetaModelFactory.inspectAggregate(RootAggregate.class, (Set)subTypes);
        TestAggregateFactory<RootAggregate> testSubject = new TestAggregateFactory<RootAggregate>(RootAggregate.class, subTypes);
        AggregateModel resultAggregateModel = testSubject.aggregateModel();
        List resultTypes = resultAggregateModel.types().collect(Collectors.toList());
        expectedAggregateModel.types().map(resultTypes::contains).forEach(Assertions::assertTrue);
    }

    private static class LeafTwoAggregate
    extends RootAggregate {
        private LeafTwoAggregate() {
        }
    }

    private static class LeafOneAggregate
    extends RootAggregate {
        private LeafOneAggregate() {
        }
    }

    private static class RootAggregate {
        private RootAggregate() {
        }
    }

    private static class TestAggregateFactory<A>
    extends AbstractAggregateFactory<A> {
        protected TestAggregateFactory(Class<A> aggregateBaseType, Set<Class<? extends A>> aggregateSubTypes) {
            super(aggregateBaseType, aggregateSubTypes);
        }

        protected A doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
            return null;
        }
    }
}

