/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.UUID;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DomainEventStreamTest {
    DomainEventStreamTest() {
    }

    @Test
    void peek() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        DomainEventStream testSubject = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2});
        Assertions.assertSame((Object)event1, (Object)testSubject.peek());
        Assertions.assertSame((Object)event1, (Object)testSubject.peek());
    }

    @Test
    void peek_EmptyStream() {
        DomainEventStream testSubject = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[0]);
        Assertions.assertFalse((boolean)testSubject.hasNext());
        try {
            testSubject.peek();
            Assertions.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    void nextAndHasNext() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        DomainEventStream testSubject = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2});
        Assertions.assertTrue((boolean)testSubject.hasNext());
        Assertions.assertSame((Object)event1, (Object)testSubject.next());
        Assertions.assertTrue((boolean)testSubject.hasNext());
        Assertions.assertSame((Object)event2, (Object)testSubject.next());
        Assertions.assertFalse((boolean)testSubject.hasNext());
    }

    @Test
    void next_ReadBeyondEnd() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        DomainEventStream testSubject = DomainEventStream.of((DomainEventMessage)event1);
        testSubject.next();
        Assertions.assertThrows(NoSuchElementException.class, () -> ((DomainEventStream)testSubject).next());
    }
}

