/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.time.Instant;
import java.util.Arrays;
import java.util.function.Predicate;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.FilteringEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class FilteringEventStorageEngineTest {
    private Predicate<EventMessage<?>> filter;
    private EventStorageEngine mockStorage;
    private FilteringEventStorageEngine testSubject;

    FilteringEventStorageEngineTest() {
    }

    @BeforeEach
    void setUp() {
        this.filter = m -> m.getPayload().toString().contains("accept");
        this.mockStorage = (EventStorageEngine)Mockito.mock(EventStorageEngine.class);
        this.testSubject = new FilteringEventStorageEngine(this.mockStorage, this.filter);
    }

    @Test
    void eventsFromArrayMatchingAreForwarded() {
        EventMessage event1 = GenericEventMessage.asEventMessage((Object)"accept");
        EventMessage event2 = GenericEventMessage.asEventMessage((Object)"fail");
        EventMessage event3 = GenericEventMessage.asEventMessage((Object)"accept");
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        ((EventStorageEngine)Mockito.verify((Object)this.mockStorage)).appendEvents(Arrays.asList(event1, event3));
    }

    @Test
    void eventsFromListMatchingAreForwarded() {
        EventMessage event1 = GenericEventMessage.asEventMessage((Object)"accept");
        EventMessage event2 = GenericEventMessage.asEventMessage((Object)"fail");
        EventMessage event3 = GenericEventMessage.asEventMessage((Object)"accept");
        this.testSubject.appendEvents(Arrays.asList(event1, event2, event3));
        ((EventStorageEngine)Mockito.verify((Object)this.mockStorage)).appendEvents(Arrays.asList(event1, event3));
    }

    @Test
    void storeSnapshotDelegated() {
        GenericDomainEventMessage snapshot = new GenericDomainEventMessage("type", "id", 0L, (Object)"fail");
        this.testSubject.storeSnapshot((DomainEventMessage)snapshot);
        ((EventStorageEngine)Mockito.verify((Object)this.mockStorage)).storeSnapshot((DomainEventMessage)snapshot);
    }

    @Test
    void createTailTokenDelegated() {
        this.testSubject.createTailToken();
        ((EventStorageEngine)Mockito.verify((Object)this.mockStorage)).createTailToken();
    }

    @Test
    void createHeadTokenDelegated() {
        this.testSubject.createHeadToken();
        ((EventStorageEngine)Mockito.verify((Object)this.mockStorage)).createHeadToken();
    }

    @Test
    void createTokenAtDelegated() {
        Instant now = Instant.now();
        this.testSubject.createTokenAt(now);
        ((EventStorageEngine)Mockito.verify((Object)this.mockStorage)).createTokenAt(now);
    }
}

