/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.ConcatenatingDomainEventStream;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class ConcatenatingDomainEventStreamTest {
    private DomainEventMessage<String> event1;
    private DomainEventMessage<String> event2;
    private DomainEventMessage<String> event3;
    private DomainEventMessage<String> event4;
    private DomainEventMessage<String> event5;

    ConcatenatingDomainEventStreamTest() {
    }

    @BeforeEach
    void setUp() {
        this.event1 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 0L, (Object)"Mock contents 1", (Map)MetaData.emptyInstance());
        this.event2 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 1L, (Object)"Mock contents 2", (Map)MetaData.emptyInstance());
        this.event3 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 2L, (Object)"Mock contents 3", (Map)MetaData.emptyInstance());
        this.event4 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 3L, (Object)"Mock contents 4", (Map)MetaData.emptyInstance());
        this.event5 = new GenericDomainEventMessage("type", UUID.randomUUID().toString(), 4L, (Object)"Mock contents 5", (Map)MetaData.emptyInstance());
    }

    @Test
    void forEachRemaining() {
        List<DomainEventMessage> expectedMessages = Arrays.asList(this.event1, this.event2, this.event3, this.event4, this.event5);
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event2}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event3, this.event4}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event3, this.event4}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event4, this.event5})});
        ArrayList actualMessages = new ArrayList();
        concat.forEachRemaining(actualMessages::add);
        Assertions.assertEquals(expectedMessages, actualMessages);
    }

    @Test
    void forEachRemainingKeepsDuplicateSequenceIdEventsInSameStream() {
        List<DomainEventMessage> expectedMessages = Arrays.asList(this.event1, this.event1, this.event2, this.event3, this.event4, this.event4, this.event5);
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event1, this.event2}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event2, this.event3}), DomainEventStream.empty(), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event3, this.event3}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event3, this.event4, this.event4}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event4, this.event5})});
        ArrayList actualMessages = new ArrayList();
        concat.forEachRemaining(actualMessages::add);
        Assertions.assertEquals(expectedMessages, actualMessages);
    }

    @Test
    void concatSkipsDuplicateEvents() {
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event2}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event2, this.event3}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event3, this.event4})});
        Assertions.assertTrue((boolean)concat.hasNext());
        Assertions.assertSame((Object)this.event1.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event2.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event3.getPayload(), (Object)concat.peek().getPayload());
        Assertions.assertSame((Object)this.event3.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event4.getPayload(), (Object)concat.peek().getPayload());
        Assertions.assertSame((Object)this.event4.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertFalse((boolean)concat.hasNext());
    }

    @Test
    public void concatDoesNotSkipDuplicateSequencesInSameStream() {
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event1, this.event2}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event2, this.event2, this.event3}), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event3, this.event4})});
        Assertions.assertTrue((boolean)concat.hasNext());
        Assertions.assertSame((Object)this.event1.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event1.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event2.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event3.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event4.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertFalse((boolean)concat.hasNext());
    }

    @Test
    void lastKnownSequenceReturnsTheLastEventItsSequence() {
        DomainEventStream lastStream = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event4, this.event5});
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of(this.event1), DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event2, this.event3}), lastStream});
        Assertions.assertTrue((boolean)concat.hasNext());
        Assertions.assertSame((Object)this.event1.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event2.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event3.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event4.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event5.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertFalse((boolean)concat.hasNext());
        Assertions.assertEquals((Long)lastStream.getLastSequenceNumber(), (Long)concat.getLastSequenceNumber());
    }

    @Test
    void lastKnownSequenceReturnsTheLastEventItsSequenceEventIfEventsHaveGaps() {
        DomainEventStream lastStream = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event4, this.event5});
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event3}), lastStream});
        Assertions.assertTrue((boolean)concat.hasNext());
        Assertions.assertSame((Object)this.event1.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event3.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event4.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertSame((Object)this.event5.getPayload(), (Object)concat.next().getPayload());
        Assertions.assertFalse((boolean)concat.hasNext());
        Assertions.assertEquals((Long)lastStream.getLastSequenceNumber(), (Long)concat.getLastSequenceNumber());
    }

    @Test
    void lastSequenceNumberWhenLastEventIsFilteredOut() {
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of(Stream.of(this.event1, this.event2).filter(x -> x != this.event2), () -> this.event2.getSequenceNumber())});
        Assertions.assertSame(this.event1, (Object)concat.next());
        Assertions.assertFalse((boolean)concat.hasNext());
        Assertions.assertEquals((long)this.event2.getSequenceNumber(), (Long)concat.getLastSequenceNumber());
    }

    @Test
    void maxLastSequenceNumberFromDelegates() {
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event3}), DomainEventStream.of(this.event2)});
        Assertions.assertSame(this.event1, (Object)concat.next());
        Assertions.assertSame(this.event3, (Object)concat.next());
        Assertions.assertFalse((boolean)concat.hasNext());
        Assertions.assertEquals((long)this.event3.getSequenceNumber(), (Long)concat.getLastSequenceNumber());
    }

    @Test
    void nullSequenceNumberFromDelegates_NullPointer() {
        ConcatenatingDomainEventStream concat = new ConcatenatingDomainEventStream(new DomainEventStream[]{DomainEventStream.of(this.event1), DomainEventStream.of(Stream.empty(), () -> null)});
        Assertions.assertEquals((long)this.event1.getSequenceNumber(), (Long)concat.getLastSequenceNumber());
    }
}

