/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Instant;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventsourcing.eventstore.EqualRevisionPredicate;
import org.axonframework.eventsourcing.utils.TestSerializer;
import org.axonframework.serialization.AnnotationRevisionResolver;
import org.axonframework.serialization.Revision;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class EqualRevisionPredicateTest {
    private static final String PAYLOAD = "payload";
    private static final String AGGREGATE = "aggregate";
    private static final String TYPE = "type";
    private static final String METADATA = "metadata";
    private EqualRevisionPredicate testSubject;

    EqualRevisionPredicateTest() {
    }

    @BeforeEach
    void setUp() {
        this.testSubject = new EqualRevisionPredicate((RevisionResolver)new AnnotationRevisionResolver(), (Serializer)TestSerializer.xStreamSerializer());
    }

    @Test
    void sameRevisionForAggregateAndPayload() {
        Assertions.assertTrue((boolean)this.testSubject.test(EqualRevisionPredicateTest.createEntry(WithAnnotationAggregate.class.getName(), "2.3-TEST")));
    }

    @Test
    void differentRevisionsForAggregateAndPayload() {
        Assertions.assertFalse((boolean)this.testSubject.test(EqualRevisionPredicateTest.createEntry(WithAnnotationAggregate.class.getName(), "2.3-TEST-DIFFERENT")));
    }

    @Test
    void noRevisionForAggregateAndPayload() {
        Assertions.assertTrue((boolean)this.testSubject.test(EqualRevisionPredicateTest.createEntry(WithoutAnnotationAggregate.class.getName())));
    }

    @Test
    void noRevisionForPayload() {
        Assertions.assertFalse((boolean)this.testSubject.test(EqualRevisionPredicateTest.createEntry(WithAnnotationAggregate.class.getName())));
    }

    @Test
    void noRevisionForAggregate() {
        Assertions.assertFalse((boolean)this.testSubject.test(EqualRevisionPredicateTest.createEntry(WithoutAnnotationAggregate.class.getName(), "2.3-TEST")));
    }

    private static DomainEventData<?> createEntry(String payloadType) {
        return EqualRevisionPredicateTest.createEntry(payloadType, null);
    }

    private static DomainEventData<?> createEntry(String payloadType, String payloadRevision) {
        return new GenericDomainEventEntry(TYPE, AGGREGATE, 0L, IdentifierFactory.getInstance().generateIdentifier(), (Object)Instant.now(), payloadType, payloadRevision, (Object)PAYLOAD, (Object)METADATA);
    }

    private static class WithoutAnnotationAggregate {
        private WithoutAnnotationAggregate() {
        }
    }

    @Revision(value="2.3-TEST")
    private static class WithAnnotationAggregate {
        private WithAnnotationAggregate() {
        }
    }
}

