/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.jpa.DomainEventEntry;
import org.axonframework.eventsourcing.utils.TestSerializer;
import org.axonframework.messaging.MetaData;
import org.axonframework.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DomainEventEntryTest {
    private final Serializer serializer = TestSerializer.xStreamSerializer();

    DomainEventEntryTest() {
    }

    @Test
    void domainEventEntryWrapEventsCorrectly() {
        Instant testTimestamp = Instant.now();
        String expectedType = "type";
        String expectedAggregateId = UUID.randomUUID().toString();
        long expectedSequenceNumber = 2L;
        String expectedPayload = "Payload";
        MetaData expectedMetaData = new MetaData(Collections.singletonMap("Key", "Value"));
        Instant expectedTimestamp = DateTimeUtils.parseInstant((CharSequence)DateTimeUtils.formatInstant((TemporalAccessor)testTimestamp));
        String expectedEventIdentifier = UUID.randomUUID().toString();
        GenericDomainEventMessage testEvent = new GenericDomainEventMessage(expectedType, expectedAggregateId, expectedSequenceNumber, (Object)expectedPayload, (Map)expectedMetaData, expectedEventIdentifier, testTimestamp);
        DomainEventEntry result = new DomainEventEntry((DomainEventMessage)testEvent, this.serializer);
        Assertions.assertEquals((Object)expectedType, (Object)result.getType());
        Assertions.assertEquals((Object)expectedAggregateId, (Object)result.getAggregateIdentifier());
        Assertions.assertEquals((long)expectedSequenceNumber, (long)result.getSequenceNumber());
        Assertions.assertEquals((Object)expectedEventIdentifier, (Object)result.getEventIdentifier());
        Assertions.assertEquals((Object)expectedTimestamp, (Object)result.getTimestamp());
        Assertions.assertEquals((Object)expectedPayload, (Object)this.serializer.deserialize(result.getPayload()));
        Assertions.assertEquals(byte[].class, (Object)result.getPayload().getContentType());
        Assertions.assertEquals((Object)expectedMetaData, (Object)this.serializer.deserialize(result.getMetaData()));
    }
}

