/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.legacyjpa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventsourcing.eventstore.legacyjpa.SQLErrorCodesResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SQLErrorCodesResolverTest {
    SQLErrorCodesResolverTest() {
    }

    @Test
    void isDuplicateKey() {
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(new ArrayList());
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)new RuntimeException()));
        Assertions.assertFalse((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingSetDuplicateKeyCodes() {
        ArrayList<Integer> errorCodes = new ArrayList<Integer>();
        errorCodes.add(-104);
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(errorCodes);
        SQLException sqlException = new SQLException("test", "error", (Integer)errorCodes.get(0));
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingDataSource() throws Exception {
        String databaseProductName = "HSQL Database Engine";
        DataSource dataSource = this.createMockDataSource(databaseProductName);
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(dataSource);
        SQLException sqlException = new SQLException("test", "error", -104);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingAS400DataSource() throws Exception {
        String databaseProductName = "DB2 UDB for AS/400";
        DataSource dataSource = this.createMockDataSource(databaseProductName);
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(dataSource);
        SQLException sqlException = new SQLException("test", "error", -803);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingDB2LinuxDataSource() throws Exception {
        String databaseProductName = "DB2/LINUXX8664";
        DataSource dataSource = this.createMockDataSource(databaseProductName);
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(dataSource);
        SQLException sqlException = new SQLException("test", "error", -803);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingRandomDb2DataSource() throws Exception {
        String databaseProductName = "DB2 Completely unexpected value";
        DataSource dataSource = this.createMockDataSource(databaseProductName);
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(dataSource);
        SQLException sqlException = new SQLException("test", "error", -803);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingProductName() {
        String databaseProductName = "HSQL Database Engine";
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(databaseProductName);
        SQLException sqlException = new SQLException("test", "error", -104);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingCustomProperties() throws Exception {
        Properties props = new Properties();
        props.setProperty("MyCustom_Database_Engine.duplicateKeyCodes", "-104");
        String databaseProductName = "MyCustom Database Engine";
        DataSource dataSource = this.createMockDataSource(databaseProductName);
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(props, dataSource);
        SQLException sqlException = new SQLException("test", "error", -104);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void initialization_UnknownProductName() throws Exception {
        DataSource dataSource = this.createMockDataSource("Some weird unknown DB type");
        Assertions.assertThrows(AxonConfigurationException.class, () -> new SQLErrorCodesResolver(dataSource));
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingSqlState() {
        Properties props = new Properties();
        props.setProperty("MyCustom_Database_Engine.duplicateKeyCodes", "-104");
        String databaseProductName = "MyCustom Database Engine";
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(props, databaseProductName);
        SQLException sqlException = new SQLException("test", "-104");
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertTrue((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingNonIntSqlState() {
        Properties props = new Properties();
        props.setProperty("MyCustom_Database_Engine.duplicateKeyCodes", "-104");
        String databaseProductName = "MyCustom Database Engine";
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(props, databaseProductName);
        SQLException sqlException = new SQLException("test", "thisIsNotAnInt");
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertFalse((boolean)isDuplicateKey);
    }

    @Test
    void isDuplicateKey_isDuplicateKey_usingNonNullSqlState() {
        Properties props = new Properties();
        props.setProperty("MyCustom_Database_Engine.duplicateKeyCodes", "-104");
        String databaseProductName = "MyCustom Database Engine";
        SQLErrorCodesResolver sqlErrorCodesResolver = new SQLErrorCodesResolver(props, databaseProductName);
        SQLException sqlException = new SQLException("test", (String)null);
        boolean isDuplicateKey = sqlErrorCodesResolver.isDuplicateKeyViolation((Exception)new PersistenceException("error", (Throwable)sqlException));
        Assertions.assertFalse((boolean)isDuplicateKey);
    }

    private DataSource createMockDataSource(String databaseProductName) throws SQLException {
        DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
        Connection connection = (Connection)Mockito.mock(Connection.class);
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)databaseMetaData.getDatabaseProductName()).thenReturn((Object)databaseProductName);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)databaseMetaData);
        Mockito.when((Object)dataSource.getConnection()).thenReturn((Object)connection);
        return dataSource;
    }
}

