/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.snapshotting;

import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.jpa.SnapshotEventEntry;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.eventsourcing.utils.TestSerializer;
import org.axonframework.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class SnapshotFilterTest {
    private static final DomainEventData<?> NO_SNAPSHOT_DATA = null;
    private static final DomainEventData<?> MOCK_SNAPSHOT_DATA = (DomainEventData)Mockito.mock(DomainEventData.class);
    private static final SnapshotEventEntry TEST_SNAPSHOT_DATA = new SnapshotEventEntry((DomainEventMessage)new GenericDomainEventMessage("some-type", "some-aggregate-id", 0L, (Object)"some-payload"), (Serializer)TestSerializer.xStreamSerializer());

    SnapshotFilterTest() {
    }

    @Test
    void allowAllReturnsTrue() {
        SnapshotFilter testSubject = SnapshotFilter.allowAll();
        Assertions.assertTrue((boolean)testSubject.allow(NO_SNAPSHOT_DATA));
        Assertions.assertTrue((boolean)testSubject.allow(MOCK_SNAPSHOT_DATA));
        Assertions.assertTrue((boolean)testSubject.allow((DomainEventData)TEST_SNAPSHOT_DATA));
    }

    @Test
    void rejectAllReturnsFalseOnAnyInput() {
        SnapshotFilter testSubject = SnapshotFilter.rejectAll();
        Assertions.assertFalse((boolean)testSubject.allow(NO_SNAPSHOT_DATA));
        Assertions.assertFalse((boolean)testSubject.allow(MOCK_SNAPSHOT_DATA));
        Assertions.assertFalse((boolean)testSubject.allow((DomainEventData)TEST_SNAPSHOT_DATA));
    }

    @Test
    void filterInvokesBothFiltersOnTrueForFirstFilter() {
        AtomicBoolean invokedFirst = new AtomicBoolean(false);
        SnapshotFilter first = snapshotData -> {
            invokedFirst.set(true);
            return true;
        };
        AtomicBoolean invokedSecond = new AtomicBoolean(false);
        SnapshotFilter second = snapshotData -> {
            invokedSecond.set(true);
            return false;
        };
        SnapshotFilter testSubject = first.combine(second);
        boolean result = testSubject.allow((DomainEventData)Mockito.mock(DomainEventData.class));
        Assertions.assertFalse((boolean)result);
        Assertions.assertTrue((boolean)invokedFirst.get());
        Assertions.assertTrue((boolean)invokedSecond.get());
    }

    @Test
    void filterInvokesFirstFilterOnlyOnFalseForFirstFilter() {
        AtomicBoolean invokedFirst = new AtomicBoolean(false);
        SnapshotFilter first = snapshotData -> {
            invokedFirst.set(true);
            return false;
        };
        AtomicBoolean invokedSecond = new AtomicBoolean(false);
        SnapshotFilter second = snapshotData -> {
            invokedSecond.set(true);
            return true;
        };
        SnapshotFilter testSubject = first.combine(second);
        boolean result = testSubject.allow((DomainEventData)Mockito.mock(DomainEventData.class));
        Assertions.assertFalse((boolean)result);
        Assertions.assertTrue((boolean)invokedFirst.get());
        Assertions.assertFalse((boolean)invokedSecond.get());
    }
}

