/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.IncompatibleAggregateException;

public class GenericAggregateFactory<T>
extends AbstractAggregateFactory<T> {
    private final Constructor<T> constructor;

    public GenericAggregateFactory(Class<T> aggregateType) {
        super(aggregateType);
        Assert.isFalse((boolean)Modifier.isAbstract(aggregateType.getModifiers()), () -> "Given aggregateType may not be abstract");
        try {
            this.constructor = (Constructor)ReflectionUtils.ensureAccessible(aggregateType.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate [%s] doesn't provide a no-arg constructor.", aggregateType.getSimpleName()), e);
        }
    }

    @Override
    protected T doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate [%s] does not have a suitable no-arg constructor.", this.getAggregateType().getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate no-arg constructor of the aggregate [%s] is not accessible. Please ensure that the constructor is public or that the Security Manager allows access through reflection.", this.getAggregateType().getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IncompatibleAggregateException(String.format("The no-arg constructor of [%s] threw an exception on invocation.", this.getAggregateType().getSimpleName()), e);
        }
    }
}

