/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;
import org.axonframework.eventsourcing.eventstore.jdbc.EventTableFactory;

public abstract class AbstractEventTableFactory
implements EventTableFactory {
    @Override
    public PreparedStatement createDomainEventTable(Connection connection, EventSchema schema) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS " + schema.domainEventTable() + " (\n" + schema.globalIndexColumn() + " " + this.idColumnType() + " NOT NULL,\n" + schema.aggregateIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.sequenceNumberColumn() + " BIGINT NOT NULL,\n" + schema.typeColumn() + " VARCHAR(255),\n" + schema.eventIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.metaDataColumn() + " " + this.payloadType() + ",\n" + schema.payloadColumn() + " " + this.payloadType() + " NOT NULL,\n" + schema.payloadRevisionColumn() + " VARCHAR(255),\n" + schema.payloadTypeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.timestampColumn() + " VARCHAR(255) NOT NULL,\nPRIMARY KEY (" + schema.globalIndexColumn() + "),\nUNIQUE (" + schema.aggregateIdentifierColumn() + ", " + schema.sequenceNumberColumn() + "),\nUNIQUE (" + schema.eventIdentifierColumn() + ")\n)";
        return connection.prepareStatement(sql);
    }

    @Override
    public PreparedStatement createSnapshotEventTable(Connection connection, EventSchema schema) throws SQLException {
        String sql = "CREATE TABLE IF NOT EXISTS " + schema.snapshotTable() + " (\n" + schema.aggregateIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.sequenceNumberColumn() + " BIGINT NOT NULL,\n" + schema.typeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.eventIdentifierColumn() + " VARCHAR(255) NOT NULL,\n" + schema.metaDataColumn() + " " + this.payloadType() + ",\n" + schema.payloadColumn() + " " + this.payloadType() + " NOT NULL,\n" + schema.payloadRevisionColumn() + " VARCHAR(255),\n" + schema.payloadTypeColumn() + " VARCHAR(255) NOT NULL,\n" + schema.timestampColumn() + " VARCHAR(255) NOT NULL,\nPRIMARY KEY (" + schema.aggregateIdentifierColumn() + ", " + schema.sequenceNumberColumn() + "),\nUNIQUE (" + schema.eventIdentifierColumn() + ")\n)";
        return connection.prepareStatement(sql);
    }

    protected abstract String idColumnType();

    protected abstract String payloadType();
}

