/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Optional;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;

public abstract class AbstractAggregateFactory<T>
implements AggregateFactory<T> {
    private final Class<T> aggregateBaseType;
    private final AggregateModel<T> aggregateModel;

    protected AbstractAggregateFactory(Class<T> aggregateBaseType) {
        this.aggregateBaseType = aggregateBaseType;
        this.aggregateModel = AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateBaseType);
    }

    protected AbstractAggregateFactory(AggregateModel<T> aggregateModel) {
        this.aggregateBaseType = aggregateModel.entityClass();
        this.aggregateModel = aggregateModel;
    }

    protected AggregateModel<T> aggregateModel() {
        return this.aggregateModel;
    }

    @Override
    public final T createAggregateRoot(String aggregateIdentifier, DomainEventMessage<?> firstEvent) {
        return this.postProcessInstance(this.fromSnapshot(firstEvent).orElse(this.doCreateAggregate(aggregateIdentifier, firstEvent)));
    }

    private Optional<T> fromSnapshot(DomainEventMessage<?> firstEvent) {
        if (this.aggregateModel.types().anyMatch(firstEvent.getPayloadType()::equals)) {
            return Optional.of(firstEvent.getPayload());
        }
        return Optional.empty();
    }

    protected T postProcessInstance(T aggregate) {
        return aggregate;
    }

    protected abstract T doCreateAggregate(String var1, DomainEventMessage var2);

    @Override
    public Class<T> getAggregateType() {
        return this.aggregateBaseType;
    }
}

