/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.eventstore.AbstractEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStorageEngineTest;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.axonframework.modelling.command.AggregateStreamCreationException;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractEventStorageEngineTest
extends EventStorageEngineTest {
    private AbstractEventStorageEngine testSubject;

    @DirtiesContext
    @Test
    public void testUniqueKeyConstraintOnFirstEventIdentifierThrowsAggregateIdentifierAlreadyExistsException() {
        Assertions.assertThrows(AggregateStreamCreationException.class, () -> this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent("id", "aggregate", 0L), EventStoreTestUtils.createEvent("id", "otherAggregate", 0L)}));
    }

    @DirtiesContext
    @Test
    public void testUniqueKeyConstraintOnEventIdentifier() {
        Assertions.assertThrows(ConcurrencyException.class, () -> this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent("id", "aggregate", 1L), EventStoreTestUtils.createEvent("id", "otherAggregate", 1L)}));
    }

    @Test
    @DirtiesContext
    public void testStoreAndLoadEventsWithUpcaster() {
        EventUpcaster mockUpcasterChain = (EventUpcaster)Mockito.mock(EventUpcaster.class);
        Mockito.when((Object)mockUpcasterChain.upcast((Stream)Mockito.isA(Stream.class))).thenAnswer(invocation -> {
            Stream inputStream = (Stream)invocation.getArguments()[0];
            return inputStream.flatMap(e -> Stream.of(e, e));
        });
        this.testSubject = this.createEngine(mockUpcasterChain);
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(4));
        List upcastedEvents = this.testSubject.readEvents("aggregate").asStream().collect(Collectors.toList());
        Assertions.assertEquals((int)8, (int)upcastedEvents.size());
        Iterator iterator = upcastedEvents.iterator();
        while (iterator.hasNext()) {
            DomainEventMessage event1 = (DomainEventMessage)iterator.next();
            DomainEventMessage event2 = (DomainEventMessage)iterator.next();
            Assertions.assertEquals((Object)event1.getAggregateIdentifier(), (Object)event2.getAggregateIdentifier());
            Assertions.assertEquals((long)event1.getSequenceNumber(), (long)event2.getSequenceNumber());
            Assertions.assertEquals((Object)event1.getPayload(), (Object)event2.getPayload());
            Assertions.assertEquals((Object)event1.getMetaData(), (Object)event2.getMetaData());
        }
    }

    @DirtiesContext
    @Test
    public void testStoreDuplicateFirstEventWithExceptionTranslatorThrowsAggregateIdentifierAlreadyExistsException() {
        Assertions.assertThrows(AggregateStreamCreationException.class, () -> this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(0L), EventStoreTestUtils.createEvent(0L)}));
    }

    @DirtiesContext
    @Test
    public void testStoreDuplicateEventWithExceptionTranslator() {
        Assertions.assertThrows(ConcurrencyException.class, () -> this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(1L), EventStoreTestUtils.createEvent(1L)}));
    }

    @DirtiesContext
    @Test
    public void testStoreDuplicateEventWithoutExceptionResolver() {
        this.testSubject = this.createEngine(e -> false);
        Assertions.assertThrows(EventStoreException.class, () -> this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(0L), EventStoreTestUtils.createEvent(0L)}));
    }

    protected void setTestSubject(AbstractEventStorageEngine testSubject) {
        this.testSubject = testSubject;
        super.setTestSubject((EventStorageEngine)this.testSubject);
    }

    protected abstract AbstractEventStorageEngine createEngine(EventUpcaster var1);

    protected abstract AbstractEventStorageEngine createEngine(PersistenceExceptionResolver var1);
}

