/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class EventStorageEngineTest {
    private EventStorageEngine testSubject;

    @AfterEach
    public void tearDown() {
        GenericEventMessage.clock = Clock.systemUTC();
    }

    @Test
    public void testStoreAndLoadEvents() {
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(4));
        Assertions.assertEquals((long)4L, (long)this.testSubject.readEvents("aggregate").asStream().count());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent("otherAggregate", 0L)});
        Assertions.assertEquals((long)4L, (long)this.testSubject.readEvents("aggregate").asStream().count());
        Assertions.assertEquals((long)1L, (long)this.testSubject.readEvents("otherAggregate").asStream().count());
    }

    @Test
    void testAppendAndReadNonDomainEvent() {
        this.testSubject.appendEvents(new EventMessage[]{new GenericEventMessage((Object)"Hello world")});
        List actual = this.testSubject.readEvents(null, false).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)actual.size());
        Assertions.assertFalse((boolean)(actual.get(0) instanceof DomainEventMessage));
    }

    @Test
    public void testStoreAndLoadEventsArray() {
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(0L), EventStoreTestUtils.createEvent(1L)});
        Assertions.assertEquals((long)2L, (long)this.testSubject.readEvents("aggregate").asStream().count());
    }

    @Test
    public void testStoreAndLoadApplicationEvent() {
        this.testSubject.appendEvents(new EventMessage[]{new GenericEventMessage((Object)"application event", (Map)MetaData.with((String)"key", (Object)"value"))});
        Assertions.assertEquals((long)1L, (long)this.testSubject.readEvents(null, false).count());
        Optional optionalFirst = this.testSubject.readEvents(null, false).findFirst();
        Assertions.assertTrue((boolean)optionalFirst.isPresent());
        EventMessage message = (EventMessage)optionalFirst.get();
        Assertions.assertEquals((Object)"application event", (Object)message.getPayload());
        Assertions.assertEquals((Object)MetaData.with((String)"key", (Object)"value"), (Object)message.getMetaData());
    }

    @Test
    public void testReturnedEventMessageBehavior() {
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent().withMetaData(Collections.singletonMap("key", "value"))});
        DomainEventMessage messageWithMetaData = this.testSubject.readEvents("aggregate").next();
        DomainEventMessage altered = messageWithMetaData.withMetaData(Collections.singletonMap("key2", "value"));
        DomainEventMessage combined = messageWithMetaData.andMetaData(Collections.singletonMap("key2", "value"));
        Assertions.assertTrue((boolean)altered.getMetaData().containsKey((Object)"key2"));
        altered.getPayload();
        Assertions.assertFalse((boolean)altered.getMetaData().containsKey((Object)"key"));
        Assertions.assertTrue((boolean)altered.getMetaData().containsKey((Object)"key2"));
        Assertions.assertTrue((boolean)combined.getMetaData().containsKey((Object)"key"));
        Assertions.assertTrue((boolean)combined.getMetaData().containsKey((Object)"key2"));
        Assertions.assertNotNull((Object)messageWithMetaData.getPayload());
        Assertions.assertNotNull((Object)messageWithMetaData.getMetaData());
        Assertions.assertFalse((boolean)messageWithMetaData.getMetaData().isEmpty());
    }

    @Test
    public void testLoadNonExistent() {
        Assertions.assertEquals((long)0L, (long)this.testSubject.readEvents(UUID.randomUUID().toString()).asStream().count());
    }

    @Test
    public void testReadPartialStream() {
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(5));
        Assertions.assertEquals((long)2L, (long)((DomainEventMessage)this.testSubject.readEvents("aggregate", 2L).asStream().findFirst().get()).getSequenceNumber());
        Assertions.assertEquals((long)4L, (long)((DomainEventMessage)this.testSubject.readEvents("aggregate", 2L).asStream().reduce((a, b) -> b).get()).getSequenceNumber());
        Assertions.assertEquals((long)3L, (long)this.testSubject.readEvents("aggregate", 2L).asStream().count());
    }

    @Test
    public void testStoreAndLoadSnapshot() {
        this.testSubject.storeSnapshot(EventStoreTestUtils.createEvent(0L));
        this.testSubject.storeSnapshot(EventStoreTestUtils.createEvent(1L));
        this.testSubject.storeSnapshot(EventStoreTestUtils.createEvent(3L));
        this.testSubject.storeSnapshot(EventStoreTestUtils.createEvent(2L));
        Assertions.assertTrue((boolean)this.testSubject.readSnapshot("aggregate").isPresent());
        Assertions.assertEquals((long)3L, (long)((DomainEventMessage)this.testSubject.readSnapshot("aggregate").get()).getSequenceNumber());
    }

    @Test
    public void testLoadTrackedEvents() throws InterruptedException {
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(4));
        Assertions.assertEquals((long)4L, (long)this.testSubject.readEvents(null, false).count());
        Thread.sleep(10L);
        DomainEventMessage<String> eventMessage = EventStoreTestUtils.createEvent("otherAggregate", 0L);
        this.testSubject.appendEvents(new EventMessage[]{eventMessage});
        Assertions.assertEquals((long)5L, (long)this.testSubject.readEvents(null, false).count());
        Assertions.assertEquals((Object)eventMessage.getIdentifier(), (Object)((TrackedEventMessage)this.testSubject.readEvents(null, false).reduce((a, b) -> b).get()).getIdentifier());
    }

    @Test
    public void testLoadPartialStreamOfTrackedEvents() {
        List<DomainEventMessage<?>> events = EventStoreTestUtils.createEvents(4);
        this.testSubject.appendEvents(events);
        TrackingToken token = ((TrackedEventMessage)this.testSubject.readEvents(null, false).findFirst().get()).trackingToken();
        Assertions.assertEquals((long)3L, (long)this.testSubject.readEvents(token, false).count());
        Assertions.assertEquals(events.subList(1, events.size()).stream().map(EventMessage::getIdentifier).collect(Collectors.toList()), this.testSubject.readEvents(token, false).map(EventMessage::getIdentifier).collect(Collectors.toList()));
    }

    @Test
    public void testCreateTailToken() {
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:00.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:35.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        TrackingToken headToken = this.testSubject.createTailToken();
        List<EventMessage<?>> readEvents = this.testSubject.readEvents(headToken, false).collect(Collectors.toList());
        this.assertEventStreamsById(Arrays.asList(event1, event2, event3), readEvents);
    }

    @Test
    public void testCreateHeadToken() {
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:00.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:35.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        TrackingToken headToken = this.testSubject.createHeadToken();
        List readEvents = this.testSubject.readEvents(headToken, false).collect(Collectors.toList());
        Assertions.assertTrue((boolean)readEvents.isEmpty());
    }

    @Test
    public void testCreateTokenAt() {
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:00.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:35.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        TrackingToken tokenAt = this.testSubject.createTokenAt(Instant.parse("2007-12-03T10:15:30.00Z"));
        List<EventMessage<?>> readEvents = this.testSubject.readEvents(tokenAt, false).collect(Collectors.toList());
        this.assertEventStreamsById(Arrays.asList(event2, event3), readEvents);
    }

    @Test
    public void testCreateTokenAtExactTime() {
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:30.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:35.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        TrackingToken tokenAt = this.testSubject.createTokenAt(Instant.parse("2007-12-03T10:15:30.00Z"));
        List<EventMessage<?>> readEvents = this.testSubject.readEvents(tokenAt, false).collect(Collectors.toList());
        this.assertEventStreamsById(Arrays.asList(event1, event2, event3), readEvents);
    }

    @Test
    public void testCreateTokenWithUnorderedEvents() {
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:30.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:50.00Z"));
        DomainEventMessage<String> event4 = EventStoreTestUtils.createEvent(3L, Instant.parse("2007-12-03T10:15:45.00Z"));
        DomainEventMessage<String> event5 = EventStoreTestUtils.createEvent(4L, Instant.parse("2007-12-03T10:15:42.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3, event4, event5});
        TrackingToken tokenAt = this.testSubject.createTokenAt(Instant.parse("2007-12-03T10:15:45.00Z"));
        List<EventMessage<?>> readEvents = this.testSubject.readEvents(tokenAt, false).collect(Collectors.toList());
        this.assertEventStreamsById(Arrays.asList(event3, event4, event5), readEvents);
    }

    @Test
    public void testCreateTokenAtTimeAfterLastEvent() {
        Instant dateTimeAfterLastEvent = Instant.parse("2008-12-03T10:15:30.00Z");
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:30.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:35.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        TrackingToken result = this.testSubject.createTokenAt(dateTimeAfterLastEvent);
        List readEvents = this.testSubject.readEvents(result, false).collect(Collectors.toList());
        Assertions.assertTrue((boolean)readEvents.isEmpty());
    }

    @Test
    public void testCreateTokenAtTimeBeforeFirstEvent() {
        Instant dateTimeBeforeFirstEvent = Instant.parse("2006-12-03T10:15:30.00Z");
        DomainEventMessage<String> event1 = EventStoreTestUtils.createEvent(0L, Instant.parse("2007-12-03T10:15:30.00Z"));
        DomainEventMessage<String> event2 = EventStoreTestUtils.createEvent(1L, Instant.parse("2007-12-03T10:15:40.00Z"));
        DomainEventMessage<String> event3 = EventStoreTestUtils.createEvent(2L, Instant.parse("2007-12-03T10:15:35.00Z"));
        this.testSubject.appendEvents(new EventMessage[]{event1, event2, event3});
        TrackingToken result = this.testSubject.createTokenAt(dateTimeBeforeFirstEvent);
        List<EventMessage<?>> readEvents = this.testSubject.readEvents(result, false).collect(Collectors.toList());
        this.assertEventStreamsById(Arrays.asList(event1, event2, event3), readEvents);
    }

    protected void setTestSubject(EventStorageEngine testSubject) {
        this.testSubject = testSubject;
    }

    protected void assertEventStreamsById(List<EventMessage<?>> s1, List<EventMessage<?>> s2) {
        Assertions.assertEquals(s1.stream().map(EventMessage::getIdentifier).collect(Collectors.toList()), s2.stream().map(EventMessage::getIdentifier).collect(Collectors.toList()));
    }
}

