/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.messaging.Message;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedMessage;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.InitialEventRepresentation;
import org.axonframework.serialization.upcasting.event.IntermediateEventRepresentation;

public abstract class EventStreamUtils {
    private EventStreamUtils() {
    }

    public static DomainEventStream upcastAndDeserializeDomainEvents(Stream<? extends DomainEventData<?>> eventEntryStream, Serializer serializer, EventUpcaster upcasterChain) {
        AtomicReference currentSequenceNumber = new AtomicReference();
        Stream<IntermediateEventRepresentation> upcastResult = EventStreamUtils.upcastAndDeserialize(eventEntryStream, upcasterChain, entry -> {
            InitialEventRepresentation result = new InitialEventRepresentation(entry, serializer);
            currentSequenceNumber.set(result.getSequenceNumber().get());
            return result;
        });
        Stream<GenericDomainEventMessage> stream = upcastResult.map(ir -> {
            SerializedMessage serializedMessage = new SerializedMessage(ir.getMessageIdentifier(), new LazyDeserializingObject(() -> ((IntermediateEventRepresentation)ir).getData(), ir.getType(), serializer), ir.getMetaData());
            if (ir.getTrackingToken().isPresent()) {
                return new GenericTrackedDomainEventMessage((TrackingToken)ir.getTrackingToken().get(), (String)ir.getAggregateType().get(), (String)ir.getAggregateIdentifier().get(), ((Long)ir.getSequenceNumber().get()).longValue(), (Message)serializedMessage, () -> ((IntermediateEventRepresentation)ir).getTimestamp());
            }
            return new GenericDomainEventMessage((String)ir.getAggregateType().get(), (String)ir.getAggregateIdentifier().get(), ((Long)ir.getSequenceNumber().get()).longValue(), (Message)serializedMessage, () -> ((IntermediateEventRepresentation)ir).getTimestamp());
        });
        return DomainEventStream.of(stream, currentSequenceNumber::get);
    }

    public static Stream<? extends DomainEventMessage<?>> asStream(DomainEventStream domainEventStream) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(domainEventStream, 273), false);
    }

    private static Stream<IntermediateEventRepresentation> upcastAndDeserialize(Stream<? extends EventData<?>> eventEntryStream, EventUpcaster upcasterChain, Function<EventData<?>, IntermediateEventRepresentation> entryConverter) {
        return upcasterChain.upcast(eventEntryStream.map(entryConverter));
    }
}

