/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventUtils;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.EventStreamUtils;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.modelling.command.AggregateStreamCreationException;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.NoOpEventUpcaster;
import org.axonframework.serialization.xml.XStreamSerializer;

public abstract class AbstractEventStorageEngine
implements EventStorageEngine {
    private final Serializer snapshotSerializer;
    protected final EventUpcaster upcasterChain;
    private final PersistenceExceptionResolver persistenceExceptionResolver;
    private final Serializer eventSerializer;
    private final SnapshotFilter snapshotFilter;

    protected AbstractEventStorageEngine(Builder builder) {
        builder.validate();
        this.snapshotSerializer = (Serializer)builder.snapshotSerializer.get();
        this.upcasterChain = builder.upcasterChain;
        this.persistenceExceptionResolver = builder.persistenceExceptionResolver;
        this.eventSerializer = (Serializer)builder.eventSerializer.get();
        this.snapshotFilter = builder.snapshotFilter;
    }

    @Override
    public Stream<? extends TrackedEventMessage<?>> readEvents(TrackingToken trackingToken, boolean mayBlock) {
        Stream<? extends TrackedEventData<?>> input = this.readEventData(trackingToken, mayBlock);
        return EventUtils.upcastAndDeserializeTrackedEvents(input, (Serializer)this.getEventSerializer(), (EventUpcaster)this.upcasterChain);
    }

    @Override
    public DomainEventStream readEvents(String aggregateIdentifier, long firstSequenceNumber) {
        Stream<? extends DomainEventData<?>> input = this.readEventData(aggregateIdentifier, firstSequenceNumber);
        return EventStreamUtils.upcastAndDeserializeDomainEvents(input, this.getEventSerializer(), this.upcasterChain);
    }

    @Override
    public Optional<DomainEventMessage<?>> readSnapshot(String aggregateIdentifier) {
        return this.readSnapshotData(aggregateIdentifier).filter(this.snapshotFilter::allow).map(snapshot -> EventStreamUtils.upcastAndDeserializeDomainEvents(Stream.of(snapshot), this.getSnapshotSerializer(), this.upcasterChain)).flatMap(DomainEventStream::asStream).findFirst().map(event -> event);
    }

    @Override
    public void appendEvents(List<? extends EventMessage<?>> events) {
        this.appendEvents(events, this.getEventSerializer());
    }

    @Override
    public void storeSnapshot(DomainEventMessage<?> snapshot) {
        this.storeSnapshot(snapshot, this.getSnapshotSerializer());
    }

    protected void handlePersistenceException(Exception exception, EventMessage<?> failedEvent) {
        String eventDescription = this.buildExceptionMessage(failedEvent);
        if (this.persistenceExceptionResolver != null && this.persistenceExceptionResolver.isDuplicateKeyViolation(exception)) {
            if (this.isFirstDomainEvent(failedEvent)) {
                throw new AggregateStreamCreationException(eventDescription, (Throwable)exception);
            }
            throw new ConcurrencyException(eventDescription, (Throwable)exception);
        }
        throw new EventStoreException(eventDescription, exception);
    }

    private boolean isFirstDomainEvent(EventMessage<?> failedEvent) {
        if (failedEvent instanceof DomainEventMessage) {
            return ((DomainEventMessage)failedEvent).getSequenceNumber() == 0L;
        }
        return false;
    }

    private String buildExceptionMessage(EventMessage<?> failedEvent) {
        String eventDescription = String.format("An event with identifier [%s] could not be persisted", failedEvent.getIdentifier());
        if (this.isFirstDomainEvent(failedEvent)) {
            DomainEventMessage failedDomainEvent = (DomainEventMessage)failedEvent;
            eventDescription = String.format("Cannot reuse aggregate identifier [%s] to create aggregate [%s] since identifiers need to be unique.", failedDomainEvent.getAggregateIdentifier(), failedDomainEvent.getType());
        } else if (failedEvent instanceof DomainEventMessage) {
            DomainEventMessage failedDomainEvent = (DomainEventMessage)failedEvent;
            eventDescription = String.format("An event for aggregate [%s] at sequence [%d] was already inserted", failedDomainEvent.getAggregateIdentifier(), failedDomainEvent.getSequenceNumber());
        }
        return eventDescription;
    }

    protected abstract void appendEvents(List<? extends EventMessage<?>> var1, Serializer var2);

    protected abstract void storeSnapshot(DomainEventMessage<?> var1, Serializer var2);

    protected abstract Stream<? extends DomainEventData<?>> readEventData(String var1, long var2);

    protected abstract Stream<? extends TrackedEventData<?>> readEventData(TrackingToken var1, boolean var2);

    protected abstract Stream<? extends DomainEventData<?>> readSnapshotData(String var1);

    public Serializer getSnapshotSerializer() {
        return this.snapshotSerializer;
    }

    public Serializer getEventSerializer() {
        return this.eventSerializer;
    }

    public static abstract class Builder {
        private Supplier<Serializer> snapshotSerializer;
        protected EventUpcaster upcasterChain = NoOpEventUpcaster.INSTANCE;
        private PersistenceExceptionResolver persistenceExceptionResolver;
        private Supplier<Serializer> eventSerializer;
        private SnapshotFilter snapshotFilter = SnapshotFilter.allowAll();

        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            BuilderUtils.assertNonNull((Object)snapshotSerializer, (String)"The Snapshot Serializer may not be null");
            this.snapshotSerializer = () -> snapshotSerializer;
            return this;
        }

        public Builder upcasterChain(EventUpcaster upcasterChain) {
            BuilderUtils.assertNonNull((Object)upcasterChain, (String)"EventUpcaster may not be null");
            this.upcasterChain = upcasterChain;
            return this;
        }

        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            this.persistenceExceptionResolver = persistenceExceptionResolver;
            return this;
        }

        public Builder eventSerializer(Serializer eventSerializer) {
            BuilderUtils.assertNonNull((Object)eventSerializer, (String)"The Event Serializer may not be null");
            this.eventSerializer = () -> eventSerializer;
            return this;
        }

        @Deprecated
        public Builder snapshotFilter(Predicate<? super DomainEventData<?>> snapshotFilter) {
            return this.snapshotFilter(snapshotFilter::test);
        }

        public Builder snapshotFilter(SnapshotFilter snapshotFilter) {
            BuilderUtils.assertNonNull((Object)snapshotFilter, (String)"The snapshotFilter may not be null");
            this.snapshotFilter = snapshotFilter;
            return this;
        }

        protected void validate() throws AxonConfigurationException {
            if (this.snapshotSerializer == null) {
                this.snapshotSerializer = XStreamSerializer::defaultSerializer;
            }
            if (this.eventSerializer == null) {
                this.eventSerializer = XStreamSerializer::defaultSerializer;
            }
        }
    }
}

