/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.axonframework.common.Assert;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackedDomainEventData;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStoreException;
import org.axonframework.eventsourcing.eventstore.jdbc.EventSchema;
import org.axonframework.eventsourcing.eventstore.jdbc.EventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcSQLErrorCodesResolver;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.AppendEventsStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.AppendSnapshotStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.CleanGapsStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.CreateHeadTokenStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.CreateTailTokenStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.CreateTokenAtStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.DeleteSnapshotsStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.FetchTrackedEventsStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.JdbcEventStorageEngineStatements;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.LastSequenceNumberForStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.ReadEventDataForAggregateStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.ReadEventDataWithGapsStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.ReadEventDataWithoutGapsStatementBuilder;
import org.axonframework.eventsourcing.eventstore.jdbc.statements.ReadSnapshotDataStatementBuilder;
import org.axonframework.eventsourcing.snapshotting.SnapshotFilter;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcEventStorageEngine
extends BatchingEventStorageEngine {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_MAX_GAP_OFFSET = 10000;
    private static final long DEFAULT_LOWEST_GLOBAL_SEQUENCE = 1L;
    private static final int DEFAULT_GAP_TIMEOUT = 60000;
    private static final int DEFAULT_GAP_CLEANING_THRESHOLD = 250;
    private static final boolean DEFAULT_EXTENDED_GAP_CHECK_ENABLED = true;
    private final ConnectionProvider connectionProvider;
    private final TransactionManager transactionManager;
    private final Class<?> dataType;
    private final EventSchema schema;
    private final int maxGapOffset;
    private final long lowestGlobalSequence;
    private final boolean extendedGapCheckEnabled;
    private int gapTimeout;
    private int gapCleaningThreshold;
    private final CreateTokenAtStatementBuilder createTokenAt;
    private final AppendEventsStatementBuilder appendEvents;
    private final LastSequenceNumberForStatementBuilder lastSequenceNumberFor;
    private final CreateTailTokenStatementBuilder createTailToken;
    private final CreateHeadTokenStatementBuilder createHeadToken;
    private final AppendSnapshotStatementBuilder appendSnapshot;
    private final DeleteSnapshotsStatementBuilder deleteSnapshots;
    private final FetchTrackedEventsStatementBuilder fetchTrackedEvents;
    private final CleanGapsStatementBuilder cleanGaps;
    private final ReadEventDataForAggregateStatementBuilder readEventDataForAggregate;
    private final ReadSnapshotDataStatementBuilder readSnapshotData;
    private final ReadEventDataWithoutGapsStatementBuilder readEventDataWithoutGaps;
    private final ReadEventDataWithGapsStatementBuilder readEventDataWithGaps;

    protected JdbcEventStorageEngine(Builder builder) {
        super(builder);
        this.connectionProvider = builder.connectionProvider;
        this.transactionManager = builder.transactionManager;
        this.dataType = builder.dataType;
        this.schema = builder.schema;
        this.lowestGlobalSequence = builder.lowestGlobalSequence;
        this.maxGapOffset = builder.maxGapOffset;
        this.gapTimeout = builder.gapTimeout;
        this.gapCleaningThreshold = builder.gapCleaningThreshold;
        this.extendedGapCheckEnabled = builder.extendedGapCheckEnabled;
        this.createTokenAt = builder.createTokenAt;
        this.appendEvents = builder.appendEvents;
        this.lastSequenceNumberFor = builder.lastSequenceNumberFor;
        this.createTailToken = builder.createTailToken;
        this.createHeadToken = builder.createHeadToken;
        this.appendSnapshot = builder.appendSnapshot;
        this.deleteSnapshots = builder.deleteSnapshots;
        this.fetchTrackedEvents = builder.fetchTrackedEvents;
        this.cleanGaps = builder.cleanGaps;
        this.readEventDataForAggregate = builder.readEventDataForAggregate;
        this.readSnapshotData = builder.readSnapshotData;
        this.readEventDataWithoutGaps = builder.readEventDataWithoutGaps;
        this.readEventDataWithGaps = builder.readEventDataWithGaps;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected PreparedStatement createTokenAt(Connection connection, Instant dateTime) throws SQLException {
        return this.createTokenAt.build(connection, this.schema, dateTime);
    }

    protected PreparedStatement appendEvents(Connection connection, List<? extends EventMessage<?>> events, Serializer serializer) throws SQLException {
        return this.appendEvents.build(connection, this.schema, this.dataType, events, serializer, this::writeTimestamp);
    }

    protected PreparedStatement lastSequenceNumberFor(Connection connection, String aggregateIdentifier) throws SQLException {
        return this.lastSequenceNumberFor.build(connection, this.schema, aggregateIdentifier);
    }

    protected PreparedStatement createTailToken(Connection connection) throws SQLException {
        return this.createTailToken.build(connection, this.schema);
    }

    protected PreparedStatement createHeadToken(Connection connection) throws SQLException {
        return this.createHeadToken.build(connection, this.schema);
    }

    protected PreparedStatement appendSnapshot(Connection connection, DomainEventMessage<?> snapshot, Serializer serializer) throws SQLException {
        return this.appendSnapshot.build(connection, this.schema, this.dataType, snapshot, serializer, this::writeTimestamp);
    }

    protected PreparedStatement deleteSnapshots(Connection connection, String aggregateIdentifier, long sequenceNumber) throws SQLException {
        return this.deleteSnapshots.build(connection, this.schema, aggregateIdentifier, sequenceNumber);
    }

    protected PreparedStatement fetchTrackedEvents(Connection connection, long index) throws SQLException {
        return this.fetchTrackedEvents.build(connection, this.schema, index);
    }

    protected PreparedStatement cleanGaps(Connection connection, SortedSet<Long> gaps) throws SQLException {
        return this.cleanGaps.build(connection, this.schema, gaps);
    }

    protected PreparedStatement readEventData(Connection connection, String identifier, long firstSequenceNumber, int batchSize) throws SQLException {
        return this.readEventDataForAggregate.build(connection, this.schema, identifier, firstSequenceNumber, batchSize);
    }

    protected PreparedStatement readSnapshotData(Connection connection, String identifier) throws SQLException {
        return this.readSnapshotData.build(connection, this.schema, identifier);
    }

    protected PreparedStatement readEventDataWithoutGaps(Connection connection, long globalIndex, int batchSize) throws SQLException {
        return this.readEventDataWithoutGaps.build(connection, this.schema, globalIndex, batchSize);
    }

    protected PreparedStatement readEventDataWithGaps(Connection connection, long globalIndex, int batchSize, List<Long> gaps) throws SQLException {
        return this.readEventDataWithGaps.build(connection, this.schema, globalIndex, batchSize, gaps);
    }

    public void createSchema(EventTableFactory schemaFactory) {
        JdbcUtils.executeUpdates((Connection)this.getConnection(), e -> {
            throw new EventStoreException("Failed to create event tables", (Throwable)e);
        }, (JdbcUtils.SqlFunction[])new JdbcUtils.SqlFunction[]{connection -> schemaFactory.createDomainEventTable(connection, this.schema), connection -> schemaFactory.createSnapshotEventTable(connection, this.schema)});
    }

    @Override
    protected void appendEvents(List<? extends EventMessage<?>> events, Serializer serializer) {
        if (events.isEmpty()) {
            return;
        }
        this.transactionManager.executeInTransaction(() -> JdbcUtils.executeBatch((Connection)this.getConnection(), connection -> this.appendEvents(connection, events, serializer), e -> this.handlePersistenceException((Exception)e, (EventMessage<?>)((EventMessage)events.get(0)))));
    }

    @Override
    protected void storeSnapshot(DomainEventMessage<?> snapshot, Serializer serializer) {
        this.transactionManager.executeInTransaction(() -> {
            try {
                JdbcUtils.executeUpdates((Connection)this.getConnection(), e -> this.handlePersistenceException((Exception)e, (EventMessage<?>)snapshot), (JdbcUtils.SqlFunction[])new JdbcUtils.SqlFunction[]{connection -> this.appendSnapshot(connection, snapshot, serializer), connection -> this.deleteSnapshots(connection, snapshot.getAggregateIdentifier(), snapshot.getSequenceNumber())});
            }
            catch (ConcurrencyException concurrencyException) {
                // empty catch block
            }
        });
    }

    @Override
    public Optional<Long> lastSequenceNumberFor(String aggregateIdentifier) {
        return Optional.ofNullable(this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.lastSequenceNumberFor(connection, aggregateIdentifier), resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException(String.format("Failed to read events for aggregate [%s]", aggregateIdentifier), (Throwable)e))));
    }

    @Override
    public TrackingToken createTailToken() {
        Long index = (Long)this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), this::createTailToken, resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException("Failed to get tail token", (Throwable)e)));
        return this.createToken(index);
    }

    @Override
    public TrackingToken createHeadToken() {
        return this.createToken(this.mostRecentIndex());
    }

    @Override
    public TrackingToken createTokenAt(Instant dateTime) {
        Long index = (Long)this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.createTokenAt(connection, dateTime), resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException(String.format("Failed to get token at [%s]", dateTime), (Throwable)e)));
        return index != null ? this.createToken(index) : this.createToken(this.mostRecentIndex());
    }

    private Long mostRecentIndex() {
        return (Long)this.transactionManager.fetchInTransaction(() -> (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), this::createHeadToken, resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException("Failed to get head token", (Throwable)e)));
    }

    private TrackingToken createToken(Long index) {
        return Optional.ofNullable(index).map(seq -> GapAwareTrackingToken.newInstance((long)seq, Collections.emptySet())).orElse(null);
    }

    @Override
    protected List<? extends DomainEventData<?>> fetchDomainEvents(String aggregateIdentifier, long firstSequenceNumber, int batchSize) {
        return (List)this.transactionManager.fetchInTransaction(() -> (List)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.readEventData(connection, aggregateIdentifier, firstSequenceNumber, batchSize), (JdbcUtils.SqlResultConverter)JdbcUtils.listResults(this::getDomainEventData), e -> new EventStoreException(String.format("Failed to read events for aggregate [%s]", aggregateIdentifier), (Throwable)e)));
    }

    @Override
    protected boolean fetchForAggregateUntilEmpty() {
        return true;
    }

    @Override
    protected List<? extends TrackedEventData<?>> fetchTrackedEvents(TrackingToken lastToken, int batchSize) {
        Assert.isTrue((lastToken == null || lastToken instanceof GapAwareTrackingToken ? 1 : 0) != 0, () -> "Unsupported token format: " + lastToken);
        List trackedEventData = (List)this.transactionManager.fetchInTransaction(() -> {
            GapAwareTrackingToken cleanedToken = lastToken != null && ((GapAwareTrackingToken)lastToken).getGaps().size() > this.gapCleaningThreshold ? this.cleanGaps(lastToken) : (GapAwareTrackingToken)lastToken;
            List<TrackedEventData<?>> eventData = this.executeEventDataQuery(cleanedToken, batchSize);
            if (this.extendedGapCheckEnabled && eventData.isEmpty()) {
                long index = cleanedToken == null ? -1L : cleanedToken.getIndex();
                Long result = (Long)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.fetchTrackedEvents(connection, index), resultSet -> (Long)JdbcUtils.nextAndExtract((ResultSet)resultSet, (int)1, Long.class), e -> new EventStoreException("Failed to read globalIndex ahead of token", (Throwable)e));
                if (result != null) {
                    return this.executeEventDataQuery(cleanedToken, (int)(result - index));
                }
            }
            return eventData;
        });
        return trackedEventData;
    }

    private List<TrackedEventData<?>> executeEventDataQuery(GapAwareTrackingToken cleanedToken, int batchSize) {
        return (List)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.readEventData(connection, (TrackingToken)cleanedToken, batchSize), resultSet -> {
            GapAwareTrackingToken previousToken = cleanedToken;
            ArrayList results = new ArrayList();
            while (resultSet.next()) {
                TrackedEventData<?> next = this.getTrackedEventData(resultSet, previousToken);
                results.add(next);
                previousToken = (GapAwareTrackingToken)next.trackingToken();
            }
            return results;
        }, e -> new EventStoreException(String.format("Failed to read events from token [%s]", cleanedToken), (Throwable)e));
    }

    private GapAwareTrackingToken cleanGaps(TrackingToken lastToken) {
        SortedSet gaps = ((GapAwareTrackingToken)lastToken).getGaps();
        return (GapAwareTrackingToken)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.cleanGaps(connection, gaps), resultSet -> {
            GapAwareTrackingToken cleanToken = (GapAwareTrackingToken)lastToken;
            while (resultSet.next()) {
                try {
                    long sequenceNumber = resultSet.getLong(this.schema.globalIndexColumn());
                    Instant timestamp = DateTimeUtils.parseInstant((CharSequence)this.readTimeStamp(resultSet, this.schema.timestampColumn()).toString());
                    if (gaps.contains(sequenceNumber) || timestamp.isAfter(this.gapTimeoutFrame())) break;
                    if (!gaps.contains(sequenceNumber - 1L)) continue;
                    cleanToken = cleanToken.withGapsTruncatedAt(sequenceNumber);
                }
                catch (DateTimeParseException e) {
                    logger.info("Unable to parse timestamp to clean old gaps. Tokens may contain large numbers of gaps, decreasing Tracking performance.");
                    break;
                }
            }
            return cleanToken;
        }, e -> new EventStoreException(String.format("Failed to read events from token [%s]", lastToken), (Throwable)e));
    }

    @Override
    protected Stream<? extends DomainEventData<?>> readSnapshotData(String aggregateIdentifier) {
        return (Stream)this.transactionManager.fetchInTransaction(() -> {
            List result = (List)JdbcUtils.executeQuery((Connection)this.getConnection(), connection -> this.readSnapshotData(connection, aggregateIdentifier), (JdbcUtils.SqlResultConverter)JdbcUtils.listResults(this::getSnapshotData), e -> new EventStoreException(String.format("Error reading aggregate snapshot [%s]", aggregateIdentifier), (Throwable)e));
            return result.stream();
        });
    }

    private PreparedStatement readEventDataWithoutToken(Connection connection, int batchSize) throws SQLException {
        return this.readEventDataWithoutGaps(connection, -1L, batchSize);
    }

    protected PreparedStatement readEventData(Connection connection, TrackingToken lastToken, int batchSize) throws SQLException {
        Assert.isTrue((lastToken == null || lastToken instanceof GapAwareTrackingToken ? 1 : 0) != 0, () -> String.format("Token [%s] is of the wrong type", lastToken));
        GapAwareTrackingToken previousToken = (GapAwareTrackingToken)lastToken;
        if (previousToken == null) {
            return this.readEventDataWithoutToken(connection, batchSize);
        }
        ArrayList<Long> gaps = new ArrayList<Long>(previousToken.getGaps());
        long globalIndex = previousToken.getIndex();
        if (gaps.isEmpty()) {
            return this.readEventDataWithoutGaps(connection, globalIndex, batchSize);
        }
        return this.readEventDataWithGaps(connection, globalIndex, batchSize, gaps);
    }

    protected TrackedEventData<?> getTrackedEventData(ResultSet resultSet, GapAwareTrackingToken previousToken) throws SQLException {
        long globalSequence = resultSet.getLong(this.schema.globalIndexColumn());
        String aggregateIdentifier = resultSet.getString(this.schema.aggregateIdentifierColumn());
        String eventIdentifier = resultSet.getString(this.schema.eventIdentifierColumn());
        GenericDomainEventEntry domainEvent = new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), eventIdentifier.equals(aggregateIdentifier) ? null : aggregateIdentifier, resultSet.getLong(this.schema.sequenceNumberColumn()), eventIdentifier, this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
        boolean allowGaps = domainEvent.getTimestamp().isAfter(this.gapTimeoutFrame());
        GapAwareTrackingToken token = previousToken;
        if (token == null) {
            token = GapAwareTrackingToken.newInstance((long)globalSequence, allowGaps ? (Collection)LongStream.range(Math.min(this.lowestGlobalSequence, globalSequence), globalSequence).boxed().collect(Collectors.toCollection(TreeSet::new)) : Collections.emptySortedSet());
        } else {
            token = token.advanceTo(globalSequence, this.maxGapOffset);
            if (!allowGaps) {
                token = token.withGapsTruncatedAt(globalSequence);
            }
        }
        return new TrackedDomainEventData((TrackingToken)token, (DomainEventData)domainEvent);
    }

    private Instant gapTimeoutFrame() {
        return GenericEventMessage.clock.instant().minus(this.gapTimeout, ChronoUnit.MILLIS);
    }

    protected DomainEventData<?> getDomainEventData(ResultSet resultSet) throws SQLException {
        return new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
    }

    protected DomainEventData<?> getSnapshotData(ResultSet resultSet) throws SQLException {
        return new GenericDomainEventEntry(resultSet.getString(this.schema.typeColumn()), resultSet.getString(this.schema.aggregateIdentifierColumn()), resultSet.getLong(this.schema.sequenceNumberColumn()), resultSet.getString(this.schema.eventIdentifierColumn()), this.readTimeStamp(resultSet, this.schema.timestampColumn()), resultSet.getString(this.schema.payloadTypeColumn()), resultSet.getString(this.schema.payloadRevisionColumn()), this.readPayload(resultSet, this.schema.payloadColumn()), this.readPayload(resultSet, this.schema.metaDataColumn()));
    }

    protected Object readTimeStamp(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getString(columnName);
    }

    protected void writeTimestamp(PreparedStatement preparedStatement, int position, Instant timestamp) throws SQLException {
        preparedStatement.setString(position, DateTimeUtils.formatInstant((TemporalAccessor)timestamp));
    }

    protected <T> T readPayload(ResultSet resultSet, String columnName) throws SQLException {
        if (byte[].class.equals(this.dataType)) {
            return (T)resultSet.getBytes(columnName);
        }
        return (T)resultSet.getObject(columnName);
    }

    @Deprecated
    protected String domainEventFields() {
        return this.schema.domainEventFields();
    }

    @Deprecated
    protected String trackedEventFields() {
        return this.schema.trackedEventFields();
    }

    protected EventSchema schema() {
        return this.schema;
    }

    protected Connection getConnection() {
        try {
            return this.connectionProvider.getConnection();
        }
        catch (SQLException e) {
            throw new EventStoreException("Failed to obtain a database connection", e);
        }
    }

    @Deprecated
    public void setGapTimeout(int gapTimeout) {
        this.gapTimeout = gapTimeout;
    }

    @Deprecated
    public void setGapCleaningThreshold(int gapCleaningThreshold) {
        this.gapCleaningThreshold = gapCleaningThreshold;
    }

    public static class Builder
    extends BatchingEventStorageEngine.Builder {
        private ConnectionProvider connectionProvider;
        private TransactionManager transactionManager;
        private Class<?> dataType = byte[].class;
        private EventSchema schema = new EventSchema();
        private int maxGapOffset = 10000;
        private long lowestGlobalSequence = 1L;
        private int gapTimeout = 60000;
        private int gapCleaningThreshold = 250;
        private boolean extendedGapCheckEnabled = true;
        private CreateTokenAtStatementBuilder createTokenAt = JdbcEventStorageEngineStatements::createTokenAt;
        private AppendEventsStatementBuilder appendEvents = JdbcEventStorageEngineStatements::appendEvents;
        private LastSequenceNumberForStatementBuilder lastSequenceNumberFor = JdbcEventStorageEngineStatements::lastSequenceNumberFor;
        private CreateTailTokenStatementBuilder createTailToken = JdbcEventStorageEngineStatements::createTailToken;
        private CreateHeadTokenStatementBuilder createHeadToken = JdbcEventStorageEngineStatements::createHeadToken;
        private AppendSnapshotStatementBuilder appendSnapshot = JdbcEventStorageEngineStatements::appendSnapshot;
        private DeleteSnapshotsStatementBuilder deleteSnapshots = JdbcEventStorageEngineStatements::deleteSnapshots;
        private FetchTrackedEventsStatementBuilder fetchTrackedEvents = JdbcEventStorageEngineStatements::fetchTrackedEvents;
        private CleanGapsStatementBuilder cleanGaps = JdbcEventStorageEngineStatements::cleanGaps;
        private ReadEventDataForAggregateStatementBuilder readEventDataForAggregate = JdbcEventStorageEngineStatements::readEventDataForAggregate;
        private ReadSnapshotDataStatementBuilder readSnapshotData = JdbcEventStorageEngineStatements::readSnapshotData;
        private ReadEventDataWithoutGapsStatementBuilder readEventDataWithoutGaps = JdbcEventStorageEngineStatements::readEventDataWithoutGaps;
        private ReadEventDataWithGapsStatementBuilder readEventDataWithGaps = JdbcEventStorageEngineStatements::readEventDataWithGaps;

        public Builder createTokenAt(CreateTokenAtStatementBuilder createTokenAt) {
            BuilderUtils.assertNonNull((Object)createTokenAt, (String)"createTokenAt may not be null");
            this.createTokenAt = createTokenAt;
            return this;
        }

        public Builder appendEvents(AppendEventsStatementBuilder appendEvents) {
            BuilderUtils.assertNonNull((Object)appendEvents, (String)"appendEvents may not be null");
            this.appendEvents = appendEvents;
            return this;
        }

        public Builder lastSequenceNumberFor(LastSequenceNumberForStatementBuilder lastSequenceNumberFor) {
            BuilderUtils.assertNonNull((Object)lastSequenceNumberFor, (String)"lastSequenceNumberFor may not be null");
            this.lastSequenceNumberFor = lastSequenceNumberFor;
            return this;
        }

        public Builder createTailToken(CreateTailTokenStatementBuilder createTailToken) {
            BuilderUtils.assertNonNull((Object)createTailToken, (String)"createTailToken may not be null");
            this.createTailToken = createTailToken;
            return this;
        }

        public Builder createHeadToken(CreateHeadTokenStatementBuilder createHeadToken) {
            BuilderUtils.assertNonNull((Object)createHeadToken, (String)"createHeadToken may not be null");
            this.createHeadToken = createHeadToken;
            return this;
        }

        public Builder appendSnapshot(AppendSnapshotStatementBuilder appendSnapshot) {
            BuilderUtils.assertNonNull((Object)appendSnapshot, (String)"appendSnapshot may not be null");
            this.appendSnapshot = appendSnapshot;
            return this;
        }

        public Builder deleteSnapshots(DeleteSnapshotsStatementBuilder deleteSnapshots) {
            BuilderUtils.assertNonNull((Object)deleteSnapshots, (String)"deleteSnapshots may not be null");
            this.deleteSnapshots = deleteSnapshots;
            return this;
        }

        public Builder fetchTrackedEvents(FetchTrackedEventsStatementBuilder fetchTrackedEvents) {
            BuilderUtils.assertNonNull((Object)fetchTrackedEvents, (String)"fetchTrackedEvents may not be null");
            this.fetchTrackedEvents = fetchTrackedEvents;
            return this;
        }

        public Builder cleanGaps(CleanGapsStatementBuilder cleanGaps) {
            BuilderUtils.assertNonNull((Object)cleanGaps, (String)"cleanGaps may not be null");
            this.cleanGaps = cleanGaps;
            return this;
        }

        public Builder readEventDataForAggregate(ReadEventDataForAggregateStatementBuilder readEventDataForAggregate) {
            BuilderUtils.assertNonNull((Object)readEventDataForAggregate, (String)"readEventDataForAggregate may not be null");
            this.readEventDataForAggregate = readEventDataForAggregate;
            return this;
        }

        public Builder readSnapshotData(ReadSnapshotDataStatementBuilder readSnapshotData) {
            BuilderUtils.assertNonNull((Object)readSnapshotData, (String)"readSnapshotData may not be null");
            this.readSnapshotData = readSnapshotData;
            return this;
        }

        public Builder readEventDataWithoutGaps(ReadEventDataWithoutGapsStatementBuilder readEventDataWithoutGaps) {
            BuilderUtils.assertNonNull((Object)readEventDataWithoutGaps, (String)"readEventDataWithoutGaps may not be null");
            this.readEventDataWithoutGaps = readEventDataWithoutGaps;
            return this;
        }

        public Builder readEventDataWithGaps(ReadEventDataWithGapsStatementBuilder readEventDataWithGaps) {
            BuilderUtils.assertNonNull((Object)readEventDataWithGaps, (String)"readEventDataWithGaps may not be null");
            this.readEventDataWithGaps = readEventDataWithGaps;
            return this;
        }

        private Builder() {
            this.persistenceExceptionResolver(new JdbcSQLErrorCodesResolver());
        }

        @Override
        public Builder snapshotSerializer(Serializer snapshotSerializer) {
            super.snapshotSerializer(snapshotSerializer);
            return this;
        }

        @Override
        public Builder upcasterChain(EventUpcaster upcasterChain) {
            super.upcasterChain(upcasterChain);
            return this;
        }

        @Override
        public Builder persistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
            super.persistenceExceptionResolver(persistenceExceptionResolver);
            return this;
        }

        @Override
        public Builder eventSerializer(Serializer eventSerializer) {
            super.eventSerializer(eventSerializer);
            return this;
        }

        @Override
        @Deprecated
        public Builder snapshotFilter(Predicate<? super DomainEventData<?>> snapshotFilter) {
            super.snapshotFilter((Predicate)snapshotFilter);
            return this;
        }

        @Override
        public Builder snapshotFilter(SnapshotFilter snapshotFilter) {
            super.snapshotFilter(snapshotFilter);
            return this;
        }

        @Override
        public Builder batchSize(int batchSize) {
            super.batchSize(batchSize);
            return this;
        }

        public Builder connectionProvider(ConnectionProvider connectionProvider) {
            BuilderUtils.assertNonNull((Object)connectionProvider, (String)"ConnectionProvider may not be null");
            this.connectionProvider = connectionProvider;
            return this;
        }

        public Builder transactionManager(TransactionManager transactionManager) {
            BuilderUtils.assertNonNull((Object)transactionManager, (String)"TransactionManager may not be null");
            this.transactionManager = transactionManager;
            return this;
        }

        public Builder dataType(Class<?> dataType) {
            BuilderUtils.assertNonNull(dataType, (String)"dataType may not be null");
            this.dataType = dataType;
            return this;
        }

        public Builder schema(EventSchema schema) {
            BuilderUtils.assertNonNull((Object)schema, (String)"EventSchema may not be null");
            this.schema = schema;
            return this;
        }

        public Builder maxGapOffset(int maxGapOffset) {
            this.assertPositive(maxGapOffset, "maxGapOffset");
            this.maxGapOffset = maxGapOffset;
            return this;
        }

        public Builder lowestGlobalSequence(long lowestGlobalSequence) {
            BuilderUtils.assertThat((Object)lowestGlobalSequence, number -> number > 0L, (String)"The lowestGlobalSequence must be a positive number");
            this.lowestGlobalSequence = lowestGlobalSequence;
            return this;
        }

        public Builder gapTimeout(int gapTimeout) {
            this.assertPositive(gapTimeout, "gapTimeout");
            this.gapTimeout = gapTimeout;
            return this;
        }

        public Builder gapCleaningThreshold(int gapCleaningThreshold) {
            this.assertPositive(gapCleaningThreshold, "gapCleaningThreshold");
            this.gapCleaningThreshold = gapCleaningThreshold;
            return this;
        }

        public Builder extendedGapCheckEnabled(boolean extendedGapCheckEnabled) {
            this.extendedGapCheckEnabled = extendedGapCheckEnabled;
            return this;
        }

        private void assertPositive(int num, String numberDescription) {
            BuilderUtils.assertThat((Object)num, number -> number > 0, (String)("The " + numberDescription + " must be a positive number"));
        }

        public JdbcEventStorageEngine build() {
            return new JdbcEventStorageEngine(this);
        }

        @Override
        protected void validate() throws AxonConfigurationException {
            super.validate();
            BuilderUtils.assertNonNull((Object)this.connectionProvider, (String)"The ConnectionProvider is a hard requirement and should be provided");
            BuilderUtils.assertNonNull((Object)this.transactionManager, (String)"The TransactionManager is a hard requirement and should be provided");
        }
    }
}

