/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Optional;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.eventstore.AbstractEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.AbstractEventStorageEngineTest;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class BatchingEventStorageEngineTest<E extends BatchingEventStorageEngine, EB extends BatchingEventStorageEngine.Builder>
extends AbstractEventStorageEngineTest<E, EB> {
    private BatchingEventStorageEngine testSubject;

    @Test
    void testLoadLargeAmountOfEvents() {
        int eventCount = this.testSubject.batchSize() + 10;
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(eventCount));
        Assertions.assertEquals((long)eventCount, (long)this.testSubject.readEvents("aggregate").asStream().count());
        Optional resultEventMessage = this.testSubject.readEvents("aggregate").asStream().reduce((a, b) -> b);
        Assertions.assertTrue((boolean)resultEventMessage.isPresent());
        Assertions.assertEquals((long)(eventCount - 1), (long)((DomainEventMessage)resultEventMessage.get()).getSequenceNumber());
    }

    protected void setTestSubject(BatchingEventStorageEngine testSubject) {
        this.testSubject = testSubject;
        super.setTestSubject((AbstractEventStorageEngine)this.testSubject);
    }
}

