/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AbstractSnapshotter;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.modelling.command.ConcurrencyException;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;

class AbstractSnapshotterTest {
    private AbstractSnapshotter testSubject;
    private EventStore mockEventStore;
    private Logger logger;
    private Logger originalLogger;
    private TestSpanFactory spanFactory;

    AbstractSnapshotterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.mockEventStore = (EventStore)Mockito.mock(EventStore.class);
        this.spanFactory = new TestSpanFactory();
        this.testSubject = TestSnapshotter.builder().eventStore(this.mockEventStore).spanFactory((SpanFactory)this.spanFactory).build();
        this.logger = (Logger)Mockito.mock(Logger.class);
        this.originalLogger = this.replaceLogger(this.logger);
    }

    @AfterEach
    void tearDown() throws Exception {
        if (this.originalLogger != null) {
            this.replaceLogger(this.originalLogger);
        }
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void scheduleSnapshot() {
        String aggregateIdentifier = "aggregateIdentifier";
        Mockito.when((Object)this.mockEventStore.readEvents(aggregateIdentifier)).thenReturn((Object)DomainEventStream.of(EventStoreTestUtils.createEvents(2)));
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event(aggregateIdentifier, 1L)));
    }

    @Test
    void snapshotTracing() {
        String aggregateIdentifier = "aggregateIdentifier";
        Mockito.when((Object)this.mockEventStore.readEvents(aggregateIdentifier)).thenAnswer(invocation -> {
            this.spanFactory.verifySpanActive("TestSnapshotter.createSnapshot(Object)");
            this.spanFactory.verifySpanActive("TestSnapshotter.createSnapshot(Object,aggregateIdentifier)");
            return DomainEventStream.of(EventStoreTestUtils.createEvents(2));
        });
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event(aggregateIdentifier, 1L)));
        this.spanFactory.verifySpanCompleted("TestSnapshotter.createSnapshot(Object)");
        this.spanFactory.verifySpanCompleted("TestSnapshotter.createSnapshot(Object,aggregateIdentifier)");
        this.spanFactory.verifySpanHasType("TestSnapshotter.createSnapshot(Object)", TestSpanFactory.TestSpanType.ROOT);
        this.spanFactory.verifySpanHasType("TestSnapshotter.createSnapshot(Object,aggregateIdentifier)", TestSpanFactory.TestSpanType.INTERNAL);
    }

    @Test
    void scheduleSnapshotIsPostponedUntilUnitOfWorkAfterCommit() {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        String aggregateIdentifier = "aggregateIdentifier";
        Mockito.when((Object)this.mockEventStore.readEvents(aggregateIdentifier)).thenReturn((Object)DomainEventStream.of(EventStoreTestUtils.createEvents(2)));
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.never())).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event(aggregateIdentifier, 1L)));
        uow.commit();
        ((EventStore)Mockito.verify((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event(aggregateIdentifier, 1L)));
    }

    @Test
    void scheduleSnapshotOnlyOnce() {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        String aggregateIdentifier = "aggregateIdentifier";
        Mockito.when((Object)this.mockEventStore.readEvents(aggregateIdentifier)).thenReturn((Object)DomainEventStream.of(EventStoreTestUtils.createEvents(2)));
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.never())).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event(aggregateIdentifier, 1L)));
        uow.commit();
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.times((int)1))).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event(aggregateIdentifier, 1L)));
    }

    @Test
    void scheduleSnapshot_ConcurrencyExceptionIsSilenced() {
        String aggregateIdentifier = "aggregateIdentifier";
        ((EventStore)Mockito.doNothing().doThrow(new Throwable[]{new ConcurrencyException("Mock")}).when((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.isA(DomainEventMessage.class));
        Mockito.when((Object)this.mockEventStore.readEvents("aggregateIdentifier")).thenAnswer(invocationOnMock -> DomainEventStream.of(EventStoreTestUtils.createEvents(2)));
        this.testSubject.scheduleSnapshot(Object.class, "aggregateIdentifier");
        this.testSubject.scheduleSnapshot(Object.class, "aggregateIdentifier");
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.times((int)2))).storeSnapshot((DomainEventMessage)Mockito.argThat(this.event("aggregateIdentifier", 1L)));
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).warn(Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).error(Mockito.anyString());
    }

    @Test
    void scheduleSnapshot_SnapshotIsNull() {
        String aggregateIdentifier = "aggregateIdentifier";
        Mockito.when((Object)this.mockEventStore.readEvents(aggregateIdentifier)).thenReturn((Object)DomainEventStream.of(EventStoreTestUtils.createEvent()));
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.never())).storeSnapshot((DomainEventMessage)Mockito.any(DomainEventMessage.class));
    }

    @Test
    void scheduleSnapshot_SnapshotReplacesOneEvent() {
        String aggregateIdentifier = "aggregateIdentifier";
        Mockito.when((Object)this.mockEventStore.readEvents(aggregateIdentifier)).thenReturn((Object)DomainEventStream.of(EventStoreTestUtils.createEvent(2L)));
        this.testSubject.scheduleSnapshot(Object.class, aggregateIdentifier);
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.never())).storeSnapshot((DomainEventMessage)Mockito.any(DomainEventMessage.class));
    }

    @Test
    void scheduleSnapshot_WithTransaction() {
        Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);
        TransactionManager txManager = (TransactionManager)Mockito.spy((Object)new StubTransactionManager(mockTransaction));
        Mockito.when((Object)txManager.startTransaction()).thenReturn((Object)mockTransaction);
        this.testSubject = TestSnapshotter.builder().eventStore(this.mockEventStore).transactionManager(txManager).build();
        this.scheduleSnapshot();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockEventStore, txManager, mockTransaction});
        ((TransactionManager)inOrder.verify((Object)txManager)).startTransaction();
        ((EventStore)inOrder.verify((Object)this.mockEventStore)).readEvents(Mockito.anyString());
        ((EventStore)inOrder.verify((Object)this.mockEventStore)).storeSnapshot((DomainEventMessage)Mockito.isA(DomainEventMessage.class));
        ((Transaction)inOrder.verify((Object)mockTransaction)).commit();
    }

    @Test
    void scheduleSnapshot_IgnoredWhenSnapshotAlreadyScheduled() {
        StubExecutor executor = new StubExecutor();
        this.testSubject = TestSnapshotter.builder().eventStore(this.mockEventStore).executor(executor).build();
        this.testSubject.scheduleSnapshot(Object.class, "id1");
        this.testSubject.scheduleSnapshot(Object.class, "id1");
        Assertions.assertEquals((int)1, (int)executor.size());
        executor.executeNext();
        Assertions.assertEquals((int)0, (int)executor.size());
        this.testSubject.scheduleSnapshot(Object.class, "id1");
        Assertions.assertEquals((int)1, (int)executor.size());
    }

    @Test
    void scheduleSnapshot_AcceptedWhenOtherSnapshotIsScheduled() {
        StubExecutor executor = new StubExecutor();
        this.testSubject = TestSnapshotter.builder().eventStore(this.mockEventStore).executor(executor).build();
        this.testSubject.scheduleSnapshot(Object.class, "id1");
        this.testSubject.scheduleSnapshot(Object.class, "id2");
        Assertions.assertEquals((int)2, (int)executor.size());
        executor.executeNext();
        Assertions.assertEquals((int)1, (int)executor.size());
        this.testSubject.scheduleSnapshot(Object.class, "id2");
        Assertions.assertEquals((int)1, (int)executor.size());
    }

    private ArgumentMatcher<DomainEventMessage> event(Object aggregateIdentifier, long i) {
        return x -> aggregateIdentifier.equals(x.getAggregateIdentifier()) && x.getSequenceNumber() == i;
    }

    private Logger replaceLogger(Logger mockLogger) throws NoSuchFieldException, IllegalAccessException {
        Field loggerField = AbstractSnapshotter.class.getDeclaredField("logger");
        ReflectionUtils.ensureAccessible((AccessibleObject)loggerField);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(loggerField, loggerField.getModifiers() & 0xFFFFFFEF);
        Logger originalLogger = (Logger)loggerField.get(null);
        loggerField.set(null, mockLogger);
        return originalLogger;
    }

    private class StubExecutor
    implements Executor {
        private final Queue<Runnable> tasks = new LinkedList<Runnable>();

        private StubExecutor() {
        }

        @Override
        public void execute(@Nonnull Runnable runnable) {
            this.tasks.add(runnable);
        }

        public boolean executeNext() {
            Runnable next = this.tasks.poll();
            if (next != null) {
                next.run();
                return true;
            }
            return false;
        }

        public int size() {
            return this.tasks.size();
        }
    }

    private static class StubTransactionManager
    implements TransactionManager {
        private final Transaction transaction;

        private StubTransactionManager(Transaction transaction) {
            this.transaction = transaction;
        }

        public Transaction startTransaction() {
            return this.transaction;
        }
    }

    private static class TestSnapshotter
    extends AbstractSnapshotter {
        private TestSnapshotter(Builder builder) {
            super((AbstractSnapshotter.Builder)builder);
        }

        private static Builder builder() {
            return new Builder();
        }

        protected DomainEventMessage createSnapshot(Class<?> aggregateType, String aggregateIdentifier, DomainEventStream eventStream) {
            long lastIdentifier = this.getLastIdentifierFrom(eventStream);
            if (lastIdentifier <= 0L) {
                return null;
            }
            return new GenericDomainEventMessage("test", aggregateIdentifier, lastIdentifier, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        }

        private long getLastIdentifierFrom(DomainEventStream eventStream) {
            long lastSequenceNumber = -1L;
            while (eventStream.hasNext()) {
                lastSequenceNumber = eventStream.next().getSequenceNumber();
            }
            return lastSequenceNumber;
        }

        private static class Builder
        extends AbstractSnapshotter.Builder {
            private Builder() {
            }

            public Builder eventStore(EventStore eventStore) {
                super.eventStore(eventStore);
                return this;
            }

            public Builder executor(Executor executor) {
                super.executor(executor);
                return this;
            }

            public Builder transactionManager(TransactionManager transactionManager) {
                super.transactionManager(transactionManager);
                return this;
            }

            public Builder spanFactory(@Nonnull SpanFactory spanFactory) {
                super.spanFactory(spanFactory);
                return this;
            }

            private TestSnapshotter build() {
                return new TestSnapshotter(this);
            }
        }
    }
}

