/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.sf.ehcache.CacheManager;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.EhCacheAdapter;
import org.axonframework.common.caching.NoCache;
import org.axonframework.eventhandling.EventHandlerInvoker;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.EventMessageHandler;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.SimpleEventHandlerInvoker;
import org.axonframework.eventhandling.SubscribingEventProcessor;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.CachingEventSourcingRepository;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.messaging.SubscribableMessageSource;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class CachingRepositoryWithNestedUnitOfWorkTest {
    private final List<String> events = new ArrayList<String>();
    private CachingEventSourcingRepository<TestAggregate> repository;
    private Cache realCache;
    private AggregateFactory<TestAggregate> aggregateFactory;
    private EventStore eventStore;

    CachingRepositoryWithNestedUnitOfWorkTest() {
    }

    @BeforeEach
    void setUp() {
        CacheManager cacheManager = CacheManager.getInstance();
        this.realCache = new EhCacheAdapter(cacheManager.addCacheIfAbsent("name"));
        this.eventStore = EmbeddedEventStore.builder().storageEngine((EventStorageEngine)new InMemoryEventStorageEngine()).build();
        SimpleEventHandlerInvoker eventHandlerInvoker = SimpleEventHandlerInvoker.builder().eventHandlers(new Object[]{new LoggingEventHandler(this.events)}).build();
        SubscribingEventProcessor eventProcessor = SubscribingEventProcessor.builder().name("test").eventHandlerInvoker((EventHandlerInvoker)eventHandlerInvoker).messageSource((SubscribableMessageSource)this.eventStore).build();
        eventProcessor.start();
        this.events.clear();
        this.aggregateFactory = new GenericAggregateFactory(TestAggregate.class);
    }

    @Test
    void withoutCache() throws Exception {
        this.repository = (CachingEventSourcingRepository)CachingEventSourcingRepository.builder(TestAggregate.class).aggregateFactory(this.aggregateFactory).eventStore(this.eventStore).cache((Cache)NoCache.INSTANCE).build();
        this.executeComplexScenario("ComplexWithoutCache");
    }

    @Test
    void withCache() throws Exception {
        this.repository = (CachingEventSourcingRepository)CachingEventSourcingRepository.builder(TestAggregate.class).aggregateFactory(this.aggregateFactory).eventStore(this.eventStore).cache(this.realCache).build();
        this.executeComplexScenario("ComplexWithCache");
    }

    @Test
    void minimalScenarioWithoutCache() throws Exception {
        this.repository = (CachingEventSourcingRepository)CachingEventSourcingRepository.builder(TestAggregate.class).aggregateFactory(this.aggregateFactory).eventStore(this.eventStore).cache((Cache)NoCache.INSTANCE).build();
        this.testMinimalScenario("MinimalScenarioWithoutCache");
    }

    @Test
    void minimalScenarioWithCache() throws Exception {
        this.repository = (CachingEventSourcingRepository)CachingEventSourcingRepository.builder(TestAggregate.class).aggregateFactory(this.aggregateFactory).eventStore(this.eventStore).cache(this.realCache).build();
        this.testMinimalScenario("MinimalScenarioWithCache");
    }

    private void testMinimalScenario(String id) throws Exception {
        SimpleEventHandlerInvoker eventHandlerInvoker = SimpleEventHandlerInvoker.builder().eventHandlers(new Object[]{new CommandExecutingEventHandler("1", null, true), new CommandExecutingEventHandler("2", null, true)}).build();
        SubscribingEventProcessor eventProcessor = SubscribingEventProcessor.builder().name("test").eventHandlerInvoker((EventHandlerInvoker)eventHandlerInvoker).messageSource((SubscribableMessageSource)this.eventStore).build();
        eventProcessor.start();
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        this.repository.newInstance(() -> new TestAggregate(id));
        uow.commit();
        TestAggregate verify = this.loadAggregate(id);
        Assertions.assertEquals((int)2, (int)verify.tokens.size());
        Assertions.assertTrue((boolean)verify.tokens.containsAll(Arrays.asList("1", "2")));
    }

    private void executeComplexScenario(String id) throws Exception {
        SimpleEventHandlerInvoker eventHandlerInvoker = SimpleEventHandlerInvoker.builder().eventHandlers(new Object[]{new CommandExecutingEventHandler("UOW4", null, true), new CommandExecutingEventHandler("UOW5", null, true), new CommandExecutingEventHandler("UOW3", null, true), new CommandExecutingEventHandler("UOW7", "UOW6", true), new CommandExecutingEventHandler("UOW6", "UOW3", true), new CommandExecutingEventHandler("UOW10", "UOW8", false), new CommandExecutingEventHandler("UOW9", "UOW4", true), new CommandExecutingEventHandler("UOW8", "UOW4", true)}).build();
        SubscribingEventProcessor eventProcessor = SubscribingEventProcessor.builder().name("test").eventHandlerInvoker((EventHandlerInvoker)eventHandlerInvoker).messageSource((SubscribableMessageSource)this.eventStore).build();
        eventProcessor.start();
        DefaultUnitOfWork uow1 = DefaultUnitOfWork.startAndGet(null);
        this.repository.newInstance(() -> new TestAggregate(id));
        uow1.commit();
        TestAggregate verify = this.loadAggregate(id);
        Assertions.assertEquals((Object)id, (Object)verify.id);
        Assertions.assertTrue((boolean)verify.tokens.containsAll(Arrays.asList("UOW3", "UOW4", "UOW5", "UOW6", "UOW7", "UOW8", "UOW9")));
        Assertions.assertFalse((boolean)verify.tokens.contains("UOW10"));
        Assertions.assertEquals((int)7, (int)verify.tokens.size());
        for (int i = 0; i < verify.tokens.size(); ++i) {
            Assertions.assertTrue((boolean)this.events.get(i).startsWith(i + " "), (String)("Expected event with sequence number " + i + " but got :" + this.events.get(i)));
        }
    }

    private TestAggregate loadAggregate(String id) {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        Aggregate verify = this.repository.load(id);
        uow.rollback();
        return (TestAggregate)verify.invoke(Function.identity());
    }

    private final class CommandExecutingEventHandler
    implements EventMessageHandler {
        private final String token;
        private final String previousToken;
        private final boolean commit;

        private CommandExecutingEventHandler(String token, String previousToken, boolean commit) {
            this.token = token;
            this.previousToken = previousToken;
            this.commit = commit;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object handle(EventMessage<?> event) {
            AggregateUpdatedEvent updated;
            DefaultUnitOfWork nested;
            Object payload = event.getPayload();
            if (this.previousToken == null && payload instanceof AggregateCreatedEvent) {
                AggregateCreatedEvent created = (AggregateCreatedEvent)payload;
                nested = DefaultUnitOfWork.startAndGet(event);
                nested.execute(() -> {
                    Aggregate aggregate = CachingRepositoryWithNestedUnitOfWorkTest.this.repository.load(created.id);
                    aggregate.execute(r -> r.update(this.token));
                });
            }
            if (this.previousToken != null && payload instanceof AggregateUpdatedEvent && (updated = (AggregateUpdatedEvent)payload).token.equals(this.previousToken)) {
                nested = DefaultUnitOfWork.startAndGet(event);
                if (this.commit) {
                    nested.execute(() -> {
                        Aggregate aggregate = CachingRepositoryWithNestedUnitOfWorkTest.this.repository.load(updated.id);
                        aggregate.execute(r -> r.update(this.token));
                    });
                } else {
                    try {
                        Aggregate aggregate = CachingRepositoryWithNestedUnitOfWorkTest.this.repository.load(updated.id);
                        aggregate.execute(r -> r.update(this.token));
                    }
                    finally {
                        nested.rollback();
                    }
                }
            }
            return null;
        }
    }

    public static class TestAggregate
    implements Serializable {
        @AggregateIdentifier
        public String id;
        public Set<String> tokens = new HashSet<String>();

        private TestAggregate() {
        }

        public TestAggregate(String id) {
            AggregateLifecycle.apply((Object)new AggregateCreatedEvent(id));
        }

        public void update(String token) {
            AggregateLifecycle.apply((Object)new AggregateUpdatedEvent(this.id, token));
        }

        @EventSourcingHandler
        private void created(AggregateCreatedEvent event) {
            this.id = event.id;
        }

        @EventSourcingHandler
        private void updated(AggregateUpdatedEvent event) {
            this.tokens.add(event.token);
        }
    }

    public static class AggregateUpdatedEvent
    implements Serializable {
        @AggregateIdentifier
        private final String id;
        private final String token;

        public AggregateUpdatedEvent(String id, String token) {
            this.id = id;
            this.token = token;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.id + "/" + this.token;
        }
    }

    public static class AggregateCreatedEvent
    implements Serializable {
        @AggregateIdentifier
        private final String id;

        public AggregateCreatedEvent(String id) {
            this.id = id;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + this.id;
        }
    }

    private static final class LoggingEventHandler
    implements EventMessageHandler {
        private final List<String> events;

        private LoggingEventHandler(List<String> events) {
            this.events = events;
        }

        public Object handle(EventMessage event) {
            GenericDomainEventMessage e = (GenericDomainEventMessage)event;
            String str = String.format("%d - %s(%s) ID %s %s", e.getSequenceNumber(), e.getPayloadType().getSimpleName(), e.getAggregateIdentifier(), e.getIdentifier(), e.getPayload());
            this.events.add(str);
            return null;
        }
    }
}

