/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.SnapshotTriggerDefinition;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.utils.StubDomainEvent;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.AggregateRoot;
import org.axonframework.modelling.command.ConflictingAggregateVersionException;
import org.axonframework.modelling.command.LockAwareAggregate;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

class EventSourcingRepositoryTest {
    private EventStore mockEventStore;
    private EventSourcingRepository<TestAggregate> testSubject;
    private UnitOfWork<?> unitOfWork;
    private StubAggregateFactory stubAggregateFactory;
    private SnapshotTriggerDefinition triggerDefinition;
    private SnapshotTrigger snapshotTrigger;
    private TestSpanFactory testSpanFactory;

    EventSourcingRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockEventStore = (EventStore)Mockito.mock(EventStore.class);
        this.stubAggregateFactory = new StubAggregateFactory();
        this.snapshotTrigger = (SnapshotTrigger)Mockito.mock(SnapshotTrigger.class);
        this.triggerDefinition = (SnapshotTriggerDefinition)Mockito.mock(SnapshotTriggerDefinition.class);
        this.testSpanFactory = new TestSpanFactory();
        Mockito.when((Object)this.triggerDefinition.prepareTrigger((Class)Mockito.any())).thenReturn((Object)this.snapshotTrigger);
        this.testSubject = EventSourcingRepository.builder(TestAggregate.class).aggregateFactory((AggregateFactory)this.stubAggregateFactory).eventStore(this.mockEventStore).snapshotTriggerDefinition(this.triggerDefinition).filterByAggregateType().spanFactory((SpanFactory)this.testSpanFactory).build();
        this.unitOfWork = DefaultUnitOfWork.startAndGet((Message)new GenericMessage((Object)"test"));
    }

    @AfterEach
    void tearDown() {
        if (this.unitOfWork.isActive()) {
            this.unitOfWork.rollback();
        }
    }

    @Test
    void loadAndSaveAggregate() {
        String identifier = UUID.randomUUID().toString();
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", identifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", identifier, 2L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2}));
        Aggregate aggregate = this.testSubject.load(identifier, null);
        Assertions.assertEquals((int)2, (int)((List)aggregate.invoke(TestAggregate::getHandledEvents)).size());
        Assertions.assertSame((Object)event1, ((List)aggregate.invoke(TestAggregate::getHandledEvents)).get(0));
        Assertions.assertSame((Object)event2, ((List)aggregate.invoke(TestAggregate::getHandledEvents)).get(1));
        Assertions.assertEquals((int)0, (int)((List)aggregate.invoke(TestAggregate::getLiveEvents)).size());
        StubDomainEvent event3 = new StubDomainEvent();
        aggregate.execute(r -> r.apply(event3));
        CurrentUnitOfWork.commit();
        ((EventStore)Mockito.verify((Object)this.mockEventStore, (VerificationMode)Mockito.times((int)1))).publish(new EventMessage[]{(EventMessage)Mockito.any()});
        Assertions.assertEquals((int)1, (int)((List)aggregate.invoke(TestAggregate::getLiveEvents)).size());
        Assertions.assertSame((Object)event3, (Object)((EventMessage)((List)aggregate.invoke(TestAggregate::getLiveEvents)).get(0)).getPayload());
    }

    @Test
    void loadAndSaveAggregateIsTracedCorrectly() {
        String identifier = UUID.randomUUID().toString();
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", identifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", identifier, 2L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenAnswer(arg_0 -> this.lambda$loadAndSaveAggregateIsTracedCorrectly$1(identifier, (DomainEventMessage)event1, (DomainEventMessage)event2, arg_0));
        Aggregate aggregate = this.testSubject.load(identifier, null);
        this.testSpanFactory.verifySpanCompleted("EventSourcingRepository.load " + identifier);
        this.testSpanFactory.verifySpanCompleted("LockingRepository.obtainLock");
        this.testSpanFactory.verifySpanCompleted("type.initializeState");
        StubDomainEvent event3 = new StubDomainEvent();
        aggregate.execute(r -> r.apply(event3));
        CurrentUnitOfWork.commit();
        this.testSpanFactory.verifySpanHasType("EventSourcingRepository.load " + identifier, TestSpanFactory.TestSpanType.INTERNAL);
        this.testSpanFactory.verifySpanHasType("LockingRepository.obtainLock", TestSpanFactory.TestSpanType.INTERNAL);
        this.testSpanFactory.verifySpanHasType("type.initializeState", TestSpanFactory.TestSpanType.INTERNAL);
    }

    @Test
    void filterEventsByType() {
        String identifier = UUID.randomUUID().toString();
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", identifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("otherType", identifier, 1L, (Object)"Other contents", (Map)MetaData.emptyInstance());
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2}));
        Aggregate aggregate = this.testSubject.load(identifier, null);
        Assertions.assertEquals((int)1, (int)((List)aggregate.invoke(TestAggregate::getHandledEvents)).size());
        Assertions.assertSame((Object)event1, ((List)aggregate.invoke(TestAggregate::getHandledEvents)).get(0));
        Assertions.assertEquals((int)0, (int)((List)aggregate.invoke(TestAggregate::getLiveEvents)).size());
    }

    @Test
    void load_FirstEventIsSnapshot() {
        String identifier = UUID.randomUUID().toString();
        TestAggregate aggregate = new TestAggregate(identifier);
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage)new GenericDomainEventMessage("type", identifier, 10L, (Object)aggregate)));
        Assertions.assertSame((Object)aggregate, (Object)((EventSourcedAggregate)((LockAwareAggregate)this.testSubject.load(identifier)).getWrappedAggregate()).getAggregateRoot());
    }

    @Test
    void loadWithConflictingChanges() {
        String identifier = UUID.randomUUID().toString();
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{new GenericDomainEventMessage("type", identifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance()), new GenericDomainEventMessage("type", identifier, 2L, (Object)"Mock contents", (Map)MetaData.emptyInstance()), new GenericDomainEventMessage("type", identifier, 3L, (Object)"Mock contents", (Map)MetaData.emptyInstance())}));
        this.testSubject.load(identifier, Long.valueOf(1L));
        try {
            CurrentUnitOfWork.commit();
            Assertions.fail((String)"Expected ConflictingAggregateVersionException");
        }
        catch (ConflictingAggregateVersionException e) {
            Assertions.assertEquals((Object)identifier, (Object)e.getAggregateIdentifier());
            Assertions.assertEquals((long)1L, (long)e.getExpectedVersion());
            Assertions.assertEquals((long)3L, (long)e.getActualVersion());
        }
    }

    @Test
    void loadWithConflictingChanges_NoConflictResolverSet_UsingTooHighExpectedVersion() {
        String identifier = UUID.randomUUID().toString();
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{new GenericDomainEventMessage("type", identifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance()), new GenericDomainEventMessage("type", identifier, 2L, (Object)"Mock contents", (Map)MetaData.emptyInstance()), new GenericDomainEventMessage("type", identifier, 3L, (Object)"Mock contents", (Map)MetaData.emptyInstance())}));
        try {
            this.testSubject.load(identifier, Long.valueOf(100L));
            Assertions.fail((String)"Expected ConflictingAggregateVersionException");
        }
        catch (ConflictingAggregateVersionException e) {
            Assertions.assertEquals((Object)identifier, (Object)e.getAggregateIdentifier());
            Assertions.assertEquals((long)100L, (long)e.getExpectedVersion());
            Assertions.assertEquals((long)3L, (long)e.getActualVersion());
        }
    }

    @Test
    void loadEventsWithSnapshotter() {
        String identifier = UUID.randomUUID().toString();
        Mockito.when((Object)this.mockEventStore.readEvents(identifier)).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{new GenericDomainEventMessage("type", identifier, 1L, (Object)"Mock contents", (Map)MetaData.emptyInstance()), new GenericDomainEventMessage("type", identifier, 2L, (Object)"Mock contents", (Map)MetaData.emptyInstance()), new GenericDomainEventMessage("type", identifier, 3L, (Object)"Mock contents", (Map)MetaData.emptyInstance())}));
        Aggregate aggregate = this.testSubject.load(identifier);
        aggregate.execute(r -> r.apply(new StubDomainEvent()));
        aggregate.execute(r -> r.apply(new StubDomainEvent()));
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.triggerDefinition, this.snapshotTrigger});
        ((SnapshotTriggerDefinition)inOrder.verify((Object)this.triggerDefinition)).prepareTrigger(this.stubAggregateFactory.getAggregateType());
        ((SnapshotTrigger)inOrder.verify((Object)this.snapshotTrigger, Mockito.times((int)3))).eventHandled((EventMessage)Mockito.any());
        ((SnapshotTrigger)inOrder.verify((Object)this.snapshotTrigger)).initializationFinished();
        ((SnapshotTrigger)inOrder.verify((Object)this.snapshotTrigger, Mockito.times((int)2))).eventHandled((EventMessage)Mockito.any());
    }

    @Test
    void buildWithNullSubtypesThrowsAxonConfigurationException() {
        EventSourcingRepository.Builder builderTestSubject = EventSourcingRepository.builder(TestAggregate.class).eventStore(this.mockEventStore);
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.subtypes(null));
    }

    @Test
    void buildWithNullSubtypeThrowsAxonConfigurationException() {
        EventSourcingRepository.Builder builderTestSubject = EventSourcingRepository.builder(TestAggregate.class).eventStore(this.mockEventStore);
        Assertions.assertThrows(AxonConfigurationException.class, () -> builderTestSubject.subtype(null));
    }

    private /* synthetic */ Object lambda$loadAndSaveAggregateIsTracedCorrectly$1(String identifier, DomainEventMessage event1, DomainEventMessage event2, InvocationOnMock invocation) throws Throwable {
        this.testSpanFactory.verifySpanActive("EventSourcingRepository.load " + identifier);
        this.testSpanFactory.verifySpanCompleted("LockingRepository.obtainLock");
        this.testSpanFactory.verifyNoSpan("type.initializeState");
        return DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2});
    }

    @AggregateRoot(type="type")
    private static class TestAggregate {
        private List<EventMessage<?>> handledEvents = new ArrayList();
        private List<EventMessage<?>> liveEvents = new ArrayList();
        @AggregateIdentifier
        private String identifier;

        private TestAggregate(String identifier) {
            this.identifier = identifier;
        }

        public void apply(Object eventPayload) {
            AggregateLifecycle.apply((Object)eventPayload);
        }

        public void changeState() {
            AggregateLifecycle.apply((Object)"Test more");
        }

        @EventSourcingHandler
        protected void handle(EventMessage event) {
            this.identifier = ((DomainEventMessage)event).getAggregateIdentifier();
            this.handledEvents.add(event);
            if (AggregateLifecycle.isLive()) {
                this.liveEvents.add(event);
            }
        }

        public List<EventMessage<?>> getHandledEvents() {
            return this.handledEvents;
        }

        public List<EventMessage<?>> getLiveEvents() {
            return this.liveEvents;
        }

        public String getIdentifier() {
            return this.identifier;
        }
    }

    private static class StubAggregateFactory
    extends AbstractAggregateFactory<TestAggregate> {
        public StubAggregateFactory() {
            super(TestAggregate.class);
        }

        public TestAggregate doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
            return new TestAggregate(aggregateIdentifier);
        }

        public Class<TestAggregate> getAggregateType() {
            return TestAggregate.class;
        }
    }
}

