/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Objects;
import java.util.concurrent.Callable;
import org.axonframework.commandhandling.CommandBus;
import org.axonframework.commandhandling.CommandHandler;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.commandhandling.SimpleCommandBus;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.modelling.command.AggregateAnnotationCommandHandler;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.Repository;
import org.axonframework.modelling.command.RepositoryProvider;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class SpawningNewAggregateTest {
    private SimpleCommandBus commandBus;
    @Mock
    private Repository<Aggregate1> aggregate1Repository;
    @Mock
    private Repository<Aggregate2> aggregate2Repository;
    @Mock
    private RepositoryProvider repositoryProvider;
    @Mock
    private EventStore eventStore;
    private AggregateModel<Aggregate1> aggregate1Model;

    SpawningNewAggregateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.commandBus = SimpleCommandBus.builder().build();
        this.aggregate1Model = AnnotatedAggregateMetaModelFactory.inspectAggregate(Aggregate1.class);
        AggregateModel aggregate2Model = AnnotatedAggregateMetaModelFactory.inspectAggregate(Aggregate2.class);
        Mockito.when((Object)this.aggregate2Repository.newInstance((Callable)Mockito.any())).thenAnswer(invocation -> EventSourcedAggregate.initialize((Callable)((Callable)invocation.getArguments()[0]), (AggregateModel)aggregate2Model, (EventBus)this.eventStore, (RepositoryProvider)this.repositoryProvider));
        Mockito.when((Object)this.repositoryProvider.repositoryFor(Aggregate2.class)).thenReturn(this.aggregate2Repository);
        AggregateAnnotationCommandHandler aggregate1CommandHandler = AggregateAnnotationCommandHandler.builder().aggregateType(Aggregate1.class).repository(this.aggregate1Repository).build();
        AggregateAnnotationCommandHandler aggregate2CommandHandler = AggregateAnnotationCommandHandler.builder().aggregateType(Aggregate2.class).repository(this.aggregate2Repository).build();
        aggregate1CommandHandler.subscribe((CommandBus)this.commandBus);
        aggregate2CommandHandler.subscribe((CommandBus)this.commandBus);
    }

    @Test
    void spawningNewAggregate() throws Exception {
        this.initializeAggregate1Repository(this.repositoryProvider);
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new CreateAggregate1Command("id", "aggregate2Id")));
        ((Repository)Mockito.verify(this.aggregate1Repository)).newInstance((Callable)Mockito.any());
        ((RepositoryProvider)Mockito.verify((Object)this.repositoryProvider)).repositoryFor(Aggregate2.class);
        ((Repository)Mockito.verify(this.aggregate2Repository)).newInstance((Callable)Mockito.any());
        ArgumentCaptor eventCaptor = ArgumentCaptor.forClass(EventMessage.class);
        ((EventStore)Mockito.verify((Object)this.eventStore, (VerificationMode)Mockito.times((int)2))).publish(new EventMessage[]{(EventMessage)eventCaptor.capture()});
        Assertions.assertEquals((Object)new Aggregate2CreatedEvent("aggregate2Id"), (Object)((EventMessage)eventCaptor.getAllValues().get(0)).getPayload());
        Assertions.assertEquals((Object)new Aggregate1CreatedEvent("id"), (Object)((EventMessage)eventCaptor.getAllValues().get(1)).getPayload());
    }

    @MockitoSettings(strictness=Strictness.LENIENT)
    @Test
    void spawningNewAggregateWhenThereIsNoRepositoryForIt() throws Exception {
        this.initializeAggregate1Repository(this.repositoryProvider);
        Mockito.when((Object)this.repositoryProvider.repositoryFor(Aggregate2.class)).thenReturn(null);
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new CreateAggregate1Command("id", "aggregate2Id")), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                Assertions.assertTrue((boolean)(cause instanceof IllegalStateException));
                Assertions.assertEquals((Object)"There is no configured repository for org.axonframework.eventsourcing.SpawningNewAggregateTest$Aggregate2", (Object)cause.getMessage());
            } else {
                Assertions.fail((String)"Expected exception");
            }
        });
    }

    @MockitoSettings(strictness=Strictness.LENIENT)
    @Test
    void spawningNewAggregateWhenThereIsNoRepositoryProviderProvided() throws Exception {
        this.initializeAggregate1Repository(null);
        this.commandBus.dispatch(GenericCommandMessage.asCommandMessage((Object)new CreateAggregate1Command("id", "aggregate2Id")), (commandMessage, commandResultMessage) -> {
            if (commandResultMessage.isExceptional()) {
                Throwable cause = commandResultMessage.exceptionResult();
                Assertions.assertTrue((boolean)(cause instanceof AxonConfigurationException));
                Assertions.assertEquals((Object)"Since repository provider is not provided, we cannot spawn a new aggregate for org.axonframework.eventsourcing.SpawningNewAggregateTest$Aggregate2", (Object)cause.getMessage());
            } else {
                Assertions.fail((String)"Expected exception");
            }
        });
    }

    private void initializeAggregate1Repository(RepositoryProvider repositoryProvider) throws Exception {
        Mockito.when((Object)this.aggregate1Repository.newInstance((Callable)Mockito.any())).thenAnswer(invocation -> EventSourcedAggregate.initialize((Callable)((Callable)invocation.getArguments()[0]), this.aggregate1Model, (EventBus)this.eventStore, (RepositoryProvider)repositoryProvider));
    }

    private static class Aggregate2 {
        @AggregateIdentifier
        private String id;
        private String state;

        public Aggregate2() {
        }

        Aggregate2(String id) {
            AggregateLifecycle.apply((Object)new Aggregate2CreatedEvent(id));
        }

        @EventSourcingHandler
        public void on(Aggregate2CreatedEvent event) {
            this.id = event.getId();
        }
    }

    private static class Aggregate1 {
        @AggregateIdentifier
        private String id;

        public Aggregate1() {
        }

        @CommandHandler
        public Aggregate1(CreateAggregate1Command command) throws Exception {
            AggregateLifecycle.apply((Object)new Aggregate1CreatedEvent(command.getId()));
            AggregateLifecycle.createNew(Aggregate2.class, () -> new Aggregate2(command.getAggregate2Id()));
        }

        @EventSourcingHandler
        public void on(Aggregate1CreatedEvent event) {
            this.id = event.getId();
        }
    }

    private static class Aggregate2CreatedEvent {
        private final String id;

        private Aggregate2CreatedEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Aggregate2CreatedEvent that = (Aggregate2CreatedEvent)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class Aggregate1CreatedEvent {
        private final String id;

        private Aggregate1CreatedEvent(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Aggregate1CreatedEvent that = (Aggregate1CreatedEvent)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    private static class CreateAggregate1Command {
        private final String id;
        private final String aggregate2Id;

        private CreateAggregate1Command(String id, String aggregate2Id) {
            this.id = id;
            this.aggregate2Id = aggregate2Id;
        }

        public String getId() {
            return this.id;
        }

        String getAggregate2Id() {
            return this.aggregate2Id;
        }
    }
}

