/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.conflictresolution;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.conflictresolution.ConflictResolution;
import org.axonframework.eventsourcing.conflictresolution.ConflictResolver;
import org.axonframework.eventsourcing.conflictresolution.NoConflictResolver;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ConflictResolutionTest {
    private Method method;
    private ConflictResolution subject;
    private ConflictResolver conflictResolver;
    private CommandMessage<String> commandMessage = new GenericCommandMessage((Object)"test");

    ConflictResolutionTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.method = this.getClass().getDeclaredMethod("handle", String.class, ConflictResolver.class);
        this.subject = new ConflictResolution();
        this.conflictResolver = (ConflictResolver)Mockito.mock(ConflictResolver.class);
        DefaultUnitOfWork.startAndGet(this.commandMessage);
    }

    @AfterEach
    void tearDown() {
        CurrentUnitOfWork.ifStarted(UnitOfWork::commit);
    }

    @Test
    void factoryMethod() {
        Assertions.assertNotNull((Object)this.subject.createInstance((Executable)this.method, this.method.getParameters(), 1));
        Assertions.assertNull((Object)this.subject.createInstance((Executable)this.method, this.method.getParameters(), 0));
    }

    @Test
    void resolve() {
        ConflictResolution.initialize((ConflictResolver)this.conflictResolver);
        Assertions.assertFalse((boolean)this.subject.matches((Message)GenericEventMessage.asEventMessage((Object)"testEvent")));
        Assertions.assertTrue((boolean)this.subject.matches(this.commandMessage));
        Assertions.assertSame((Object)this.conflictResolver, (Object)ConflictResolution.getConflictResolver());
        Assertions.assertSame((Object)this.conflictResolver, (Object)this.subject.resolveParameterValue(this.commandMessage));
    }

    @Test
    void resolveWithoutInitializationReturnsNoConflictsResolver() {
        Assertions.assertTrue((boolean)this.subject.matches(this.commandMessage));
        Assertions.assertSame((Object)NoConflictResolver.INSTANCE, (Object)this.subject.resolveParameterValue(this.commandMessage));
    }

    private void handle(String command, ConflictResolver conflictResolver) {
    }
}

