/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import com.mysql.cj.jdbc.MysqlDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventsourcing.eventstore.jdbc.EventTableFactory;
import org.axonframework.eventsourcing.eventstore.jdbc.JdbcEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jdbc.MySqlEventTableFactory;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.axonframework.eventsourcing.utils.TestSerializer;
import org.axonframework.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.MySQLContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class MysqlJdbcEventStorageEngineTest {
    @Container
    private static final MySQLContainer<?> MYSQL_CONTAINER = new MySQLContainer("mysql").withDatabaseName("axon").withUsername("admin").withPassword("some-password");
    private JdbcEventStorageEngine testSubject;

    MysqlJdbcEventStorageEngineTest() {
    }

    @BeforeEach
    void setUp() throws SQLException {
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setUrl(MYSQL_CONTAINER.getJdbcUrl());
        dataSource.setUser(MYSQL_CONTAINER.getUsername());
        dataSource.setPassword(MYSQL_CONTAINER.getPassword());
        this.testSubject = this.createEngine(dataSource);
    }

    @Test
    void loadLastSequenceNumber() {
        String aggregateId = UUID.randomUUID().toString();
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(aggregateId, 0L), EventStoreTestUtils.createEvent(aggregateId, 1L)});
        Assertions.assertEquals((long)1L, (long)this.testSubject.lastSequenceNumberFor(aggregateId).orElse(-1L));
        Assertions.assertFalse((boolean)this.testSubject.lastSequenceNumberFor("nonexistent").isPresent());
    }

    private JdbcEventStorageEngine createEngine(MysqlDataSource dataSource) throws SQLException {
        JdbcEventStorageEngine engine = JdbcEventStorageEngine.builder().snapshotSerializer((Serializer)TestSerializer.xStreamSerializer()).persistenceExceptionResolver((PersistenceExceptionResolver)new SQLErrorCodesResolver((DataSource)dataSource)).eventSerializer((Serializer)TestSerializer.xStreamSerializer()).connectionProvider(() -> ((MysqlDataSource)dataSource).getConnection()).transactionManager((TransactionManager)NoTransactionManager.INSTANCE).build();
        try {
            Connection connection = dataSource.getConnection();
            connection.prepareStatement("DROP TABLE IF EXISTS DomainEventEntry").executeUpdate();
            connection.prepareStatement("DROP TABLE IF EXISTS SnapshotEventEntry").executeUpdate();
            engine.createSchema((EventTableFactory)MySqlEventTableFactory.INSTANCE);
            return engine;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }
}

