/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jpa;

import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.jpa.SimpleEntityManagerProvider;
import org.axonframework.common.transaction.NoTransactionManager;
import org.axonframework.common.transaction.Transaction;
import org.axonframework.common.transaction.TransactionManager;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventData;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GapAwareTrackingToken;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.TrackedEventData;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingEventStream;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngineTest;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jpa.CustomDomainEventEntry;
import org.axonframework.eventsourcing.eventstore.jpa.CustomSnapshotEventEntry;
import org.axonframework.eventsourcing.eventstore.jpa.JpaEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.jpa.SQLErrorCodesResolver;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.axonframework.eventsourcing.utils.TestSerializer;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.UnknownSerializedType;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.NoOpEventUpcaster;
import org.axonframework.serialization.xml.XStreamSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.test.annotation.DirtiesContext;

class JpaEventStorageEngineTest
extends BatchingEventStorageEngineTest<JpaEventStorageEngine, JpaEventStorageEngine.Builder> {
    private JpaEventStorageEngine testSubject;
    private final EntityManagerFactory entityManagerFactory = Persistence.createEntityManagerFactory((String)"eventStore");
    private final EntityManager entityManager = this.entityManagerFactory.createEntityManager();
    private final EntityManagerProvider entityManagerProvider = new SimpleEntityManagerProvider(this.entityManager);
    private final TransactionManager transactionManager = (TransactionManager)Mockito.spy((Object)new NoOpTransactionManager());
    private EntityTransaction transaction;
    private PersistenceExceptionResolver defaultPersistenceExceptionResolver;

    JpaEventStorageEngineTest() {
    }

    @BeforeEach
    void setUp() {
        String databaseProductName = "HSQL Database Engine";
        this.defaultPersistenceExceptionResolver = new SQLErrorCodesResolver(databaseProductName);
        this.testSubject = (JpaEventStorageEngine)this.createEngine();
        this.setTestSubject((BatchingEventStorageEngine)this.testSubject);
        this.transaction = this.entityManager.getTransaction();
        this.transaction.begin();
        this.entityManager.createQuery("DELETE FROM DomainEventEntry dee").executeUpdate();
        this.transaction.commit();
        this.entityManager.clear();
        this.transaction.begin();
    }

    @AfterEach
    public void cleanup() {
        this.transaction.commit();
    }

    @Test
    void storeAndLoadEventsFromDatastore() {
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(2));
        this.entityManager.clear();
        Assertions.assertEquals((long)2L, (long)this.testSubject.readEvents("aggregate").asStream().count());
    }

    @Test
    void loadLastSequenceNumber() {
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(2));
        this.entityManager.clear();
        Assertions.assertEquals((long)1L, (long)this.testSubject.lastSequenceNumberFor("aggregate").orElse(-1L));
        Assertions.assertFalse((boolean)this.testSubject.lastSequenceNumberFor(UUID.randomUUID().toString()).isPresent());
    }

    @Test
    void gapsForVeryOldEventsAreNotIncluded() {
        this.entityManager.createQuery("DELETE FROM DomainEventEntry dee").executeUpdate();
        GenericEventMessage.clock = Clock.fixed(Clock.systemUTC().instant().minus(1L, ChronoUnit.HOURS), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-1L), EventStoreTestUtils.createEvent(0L)});
        GenericEventMessage.clock = Clock.fixed(Clock.systemUTC().instant().minus(2L, ChronoUnit.MINUTES), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-2L), EventStoreTestUtils.createEvent(1L)});
        GenericEventMessage.clock = Clock.fixed(Clock.systemUTC().instant().minus(50L, ChronoUnit.SECONDS), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-3L), EventStoreTestUtils.createEvent(2L)});
        GenericEventMessage.clock = Clock.fixed(Clock.systemUTC().instant(), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-4L), EventStoreTestUtils.createEvent(3L)});
        this.entityManager.clear();
        this.entityManager.createQuery("DELETE FROM DomainEventEntry dee WHERE dee.sequenceNumber < 0").executeUpdate();
        this.testSubject.fetchTrackedEvents(null, 100).stream().map(i -> (GapAwareTrackingToken)i.trackingToken()).forEach(i -> Assertions.assertTrue((!i.hasGaps() || (Long)i.getGaps().first() >= 5L ? 1 : 0) != 0));
    }

    @DirtiesContext
    @Test
    void oldGapsAreRemovedFromProvidedTrackingToken() {
        this.testSubject.setGapCleaningThreshold(50);
        this.testSubject.setGapTimeout(50001);
        Instant now = Clock.systemUTC().instant();
        GenericEventMessage.clock = Clock.fixed(now.minus(1L, ChronoUnit.HOURS), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-1L), EventStoreTestUtils.createEvent("aggregateId", 0L)});
        GenericEventMessage.clock = Clock.fixed(now.minus(2L, ChronoUnit.MINUTES), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-2L), EventStoreTestUtils.createEvent("aggregateId", 1L)});
        GenericEventMessage.clock = Clock.fixed(now.minus(50L, ChronoUnit.SECONDS), Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-3L), EventStoreTestUtils.createEvent("aggregateId", 2L)});
        GenericEventMessage.clock = Clock.fixed(now, Clock.systemUTC().getZone());
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent(-4L), EventStoreTestUtils.createEvent("aggregateId", 3L)});
        this.entityManager.clear();
        this.entityManager.createQuery("DELETE FROM DomainEventEntry dee WHERE dee.aggregateIdentifier <> :aggregateIdentifier").setParameter("aggregateIdentifier", (Object)"aggregateId").executeUpdate();
        List sequences = this.entityManager.createQuery("SELECT e.globalIndex FROM DomainEventEntry e WHERE e.aggregateIdentifier = :aggregateIdentifier", Long.class).setParameter("aggregateIdentifier", (Object)"aggregateId").getResultList();
        Optional maxResult = sequences.stream().max(Long::compareTo);
        Assertions.assertTrue((boolean)maxResult.isPresent());
        long largestIndex = (Long)maxResult.get();
        long secondLastEventIndex = largestIndex - 2L;
        List gaps = LongStream.range(-50L, largestIndex).boxed().filter(g -> !sequences.contains(g)).filter(g -> g < secondLastEventIndex).collect(Collectors.toList());
        List events = this.testSubject.fetchTrackedEvents((TrackingToken)GapAwareTrackingToken.newInstance((long)secondLastEventIndex, gaps), 100);
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals((long)(secondLastEventIndex - 1L), (long)((Long)((GapAwareTrackingToken)((TrackedEventData)events.get(0)).trackingToken()).getGaps().first()));
        Assertions.assertEquals((int)2, (int)((GapAwareTrackingToken)((TrackedEventData)events.get(0)).trackingToken()).getGaps().size());
    }

    @Test
    void unknownSerializedTypeCausesException() {
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent()});
        this.entityManager.createQuery("UPDATE DomainEventEntry e SET e.payloadType = :type").setParameter("type", (Object)"unknown").executeUpdate();
        DomainEventMessage actual = this.testSubject.readEvents("aggregate").peek();
        Assertions.assertEquals(UnknownSerializedType.class, (Object)actual.getPayloadType());
    }

    @Test
    @DirtiesContext
    void storeEventsWithCustomEntity() {
        XStreamSerializer serializer = TestSerializer.xStreamSerializer();
        JpaEventStorageEngine.Builder jpaEventStorageEngineBuilder = JpaEventStorageEngine.builder().snapshotSerializer((Serializer)serializer).persistenceExceptionResolver(this.defaultPersistenceExceptionResolver).eventSerializer((Serializer)serializer).entityManagerProvider(this.entityManagerProvider).transactionManager((TransactionManager)NoTransactionManager.INSTANCE).explicitFlush(false);
        this.testSubject = new JpaEventStorageEngine(jpaEventStorageEngineBuilder){

            protected EventData<?> createEventEntity(EventMessage<?> eventMessage, Serializer serializer) {
                return new CustomDomainEventEntry((DomainEventMessage)eventMessage, serializer);
            }

            protected DomainEventData<?> createSnapshotEntity(DomainEventMessage<?> snapshot, Serializer serializer) {
                return new CustomSnapshotEventEntry(snapshot, serializer);
            }

            protected String domainEventEntryEntityName() {
                return CustomDomainEventEntry.class.getSimpleName();
            }

            protected String snapshotEventEntryEntityName() {
                return CustomSnapshotEventEntry.class.getSimpleName();
            }
        };
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent("aggregate", 1L, "Payload1")});
        this.testSubject.storeSnapshot(EventStoreTestUtils.createEvent("aggregate", 1L, "Snapshot1"));
        this.entityManager.flush();
        this.entityManager.clear();
        Assertions.assertFalse((boolean)this.entityManager.createQuery("SELECT e FROM CustomDomainEventEntry e").getResultList().isEmpty());
        Assertions.assertEquals((Object)"Snapshot1", (Object)((DomainEventMessage)this.testSubject.readSnapshot("aggregate").get()).getPayload());
        Assertions.assertEquals((Object)"Payload1", (Object)this.testSubject.readEvents("aggregate").peek().getPayload());
    }

    @Test
    void eventsWithUnknownPayloadDoNotResultInError() throws InterruptedException {
        String expectedPayloadOne = "Payload3";
        String expectedPayloadTwo = "Payload4";
        int testBatchSize = 2;
        this.testSubject = this.createEngine(engineBuilder -> engineBuilder.batchSize(testBatchSize));
        EmbeddedEventStore testEventStore = EmbeddedEventStore.builder().storageEngine((EventStorageEngine)this.testSubject).build();
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent("aggregate", 1L, "Payload1"), EventStoreTestUtils.createEvent("aggregate", 2L, "Payload2")});
        this.entityManager.createQuery("UPDATE DomainEventEntry e SET e.payloadType = :type").setParameter("type", (Object)"unknown").executeUpdate();
        this.testSubject.appendEvents(new EventMessage[]{EventStoreTestUtils.createEvent("aggregate", 3L, expectedPayloadOne), EventStoreTestUtils.createEvent("aggregate", 4L, expectedPayloadTwo)});
        List eventStorageEngineResult = this.testSubject.readEvents(null, false).filter(m -> m.getPayload() instanceof String).map(m -> (String)m.getPayload()).collect(Collectors.toList());
        Assertions.assertEquals(Arrays.asList(expectedPayloadOne, expectedPayloadTwo), eventStorageEngineResult);
        TrackingEventStream eventStoreResult = testEventStore.openStream(null);
        Assertions.assertTrue((boolean)eventStoreResult.hasNextAvailable());
        Assertions.assertEquals(UnknownSerializedType.class, (Object)((TrackedEventMessage)eventStoreResult.nextAvailable()).getPayloadType());
        Assertions.assertEquals(UnknownSerializedType.class, (Object)((TrackedEventMessage)eventStoreResult.nextAvailable()).getPayloadType());
        Assertions.assertEquals((Object)expectedPayloadOne, (Object)((TrackedEventMessage)eventStoreResult.nextAvailable()).getPayload());
        Assertions.assertEquals((Object)expectedPayloadTwo, (Object)((TrackedEventMessage)eventStoreResult.nextAvailable()).getPayload());
        Assertions.assertFalse((boolean)eventStoreResult.hasNextAvailable());
    }

    @Test
    void appendEventsIsPerformedInATransaction() {
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(2));
        ((TransactionManager)Mockito.verify((Object)this.transactionManager)).executeInTransaction((Runnable)Mockito.any());
    }

    @Override
    protected JpaEventStorageEngine createEngine(UnaryOperator<JpaEventStorageEngine.Builder> customization) {
        JpaEventStorageEngine.Builder engineBuilder = JpaEventStorageEngine.builder().upcasterChain((EventUpcaster)NoOpEventUpcaster.INSTANCE).persistenceExceptionResolver(this.defaultPersistenceExceptionResolver).batchSize(100).entityManagerProvider(this.entityManagerProvider).transactionManager(this.transactionManager).eventSerializer((Serializer)TestSerializer.xStreamSerializer()).snapshotSerializer((Serializer)TestSerializer.xStreamSerializer());
        return new JpaEventStorageEngine((JpaEventStorageEngine.Builder)customization.apply(engineBuilder));
    }

    private static class NoOpTransactionManager
    implements TransactionManager {
        private NoOpTransactionManager() {
        }

        public Transaction startTransaction() {
            return new Transaction(){

                public void commit() {
                }

                public void rollback() {
                }
            };
        }
    }
}

