/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Map;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AggregateLoadTimeSnapshotTriggerDefinition;
import org.axonframework.eventsourcing.SnapshotTrigger;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.utils.StubAggregate;
import org.axonframework.messaging.GenericMessage;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MetaData;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregate;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AggregateLoadSnapshotTriggerDefinitionTest {
    private AggregateLoadTimeSnapshotTriggerDefinition testSubject;
    private Snapshotter mockSnapshotter;
    private String aggregateIdentifier;
    private Aggregate<?> aggregate;
    private Instant now;

    AggregateLoadSnapshotTriggerDefinitionTest() {
    }

    @BeforeEach
    void setUp() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
        this.mockSnapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        this.testSubject = new AggregateLoadTimeSnapshotTriggerDefinition(this.mockSnapshotter, 1000L);
        this.aggregateIdentifier = "aggregateIdentifier";
        DefaultUnitOfWork.startAndGet((Message)new GenericMessage((Object)"test"));
        this.aggregate = AnnotatedAggregate.initialize((Object)new StubAggregate(this.aggregateIdentifier), (AggregateModel)AnnotatedAggregateMetaModelFactory.inspectAggregate(StubAggregate.class), null);
        this.now = Instant.now();
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now, ZoneId.of("UTC"));
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
    }

    @Test
    void snapshotterTriggeredOnUnitOfWorkCleanup() {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1001L), ZoneId.of("UTC"));
        trigger.eventHandled((EventMessage)msg);
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
        CurrentUnitOfWork.get().onCommit(uow -> ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier));
        CurrentUnitOfWork.commit();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter)).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
    }

    @Test
    void snapshotterTriggeredOnUnitOfWorkCommit() {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1001L), ZoneId.of("UTC"));
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        trigger.initializationFinished();
        trigger.eventHandled((EventMessage)msg);
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
        CurrentUnitOfWork.commit();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter)).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
    }

    @Test
    void snapshotterIsNotTriggeredOnUnitOfWorkRollbackIfEventsHandledAfterInitialization() {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1001L), ZoneId.of("UTC"));
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        trigger.initializationFinished();
        trigger.eventHandled((EventMessage)msg);
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
        CurrentUnitOfWork.get().rollback();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
    }

    @Test
    void snapshotterTriggeredOnUnitOfWorkRollbackWhenEventsHandledBeforeInitialization() {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1001L), ZoneId.of("UTC"));
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        trigger.eventHandled((EventMessage)msg);
        trigger.initializationFinished();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
        CurrentUnitOfWork.get().rollback();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter)).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
    }

    @Test
    void snapshotterNotTriggered() {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1000L), ZoneId.of("UTC"));
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        trigger.eventHandled((EventMessage)msg);
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.getClass(), this.aggregateIdentifier);
        CurrentUnitOfWork.commit();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.getClass(), this.aggregateIdentifier);
    }

    @Test
    void thresholdDoesNotResetWhenSerialized() throws IOException, ClassNotFoundException {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1001L), ZoneId.of("UTC"));
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        trigger.eventHandled((EventMessage)msg);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(trigger);
        trigger = (SnapshotTrigger)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        this.testSubject.reconfigure(this.aggregate.rootType(), trigger);
        trigger.eventHandled((EventMessage)msg);
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter, (VerificationMode)Mockito.never())).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
        CurrentUnitOfWork.commit();
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter)).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
    }

    @Test
    void scheduleANewSnapshotAfterCommitTrigger() {
        SnapshotTrigger trigger = this.testSubject.prepareTrigger(this.aggregate.rootType());
        AggregateLoadTimeSnapshotTriggerDefinition.clock = Clock.fixed(this.now.plusMillis(1001L), ZoneId.of("UTC"));
        GenericDomainEventMessage msg = new GenericDomainEventMessage("type", this.aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        CurrentUnitOfWork.commit();
        trigger.eventHandled((EventMessage)msg);
        ((Snapshotter)Mockito.verify((Object)this.mockSnapshotter)).scheduleSnapshot(this.aggregate.rootType(), this.aggregateIdentifier);
    }
}

