/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.EventSourcingHandler;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.utils.StubDomainEvent;
import org.axonframework.messaging.MetaData;
import org.axonframework.modelling.command.AggregateIdentifier;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AggregateSnapshotterTest {
    private AggregateSnapshotter testSubject;
    private AggregateFactory mockAggregateFactory;

    @BeforeEach
    void setUp() {
        this.mockAggregateFactory = (AggregateFactory)Mockito.mock(AggregateFactory.class);
        Mockito.when((Object)this.mockAggregateFactory.getAggregateType()).thenReturn(StubAggregate.class);
        this.testSubject = AggregateSnapshotter.builder().eventStore((EventStore)Mockito.mock(EventStore.class)).aggregateFactories(Collections.singletonList(this.mockAggregateFactory)).build();
    }

    @Test
    void createSnapshot() {
        String aggregateIdentifier = UUID.randomUUID().toString();
        GenericDomainEventMessage firstEvent = new GenericDomainEventMessage("type", aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        DomainEventStream eventStream = DomainEventStream.of((DomainEventMessage)firstEvent);
        StubAggregate aggregate = new StubAggregate(aggregateIdentifier);
        Mockito.when((Object)this.mockAggregateFactory.createAggregateRoot(aggregateIdentifier, (DomainEventMessage)firstEvent)).thenReturn((Object)aggregate);
        DomainEventMessage snapshot = this.testSubject.createSnapshot(StubAggregate.class, aggregateIdentifier, eventStream);
        ((AggregateFactory)Mockito.verify((Object)this.mockAggregateFactory)).createAggregateRoot(aggregateIdentifier, (DomainEventMessage)firstEvent);
        Assertions.assertSame((Object)aggregate, (Object)snapshot.getPayload());
    }

    @Test
    void createSnapshot_FirstEventLoadedIsSnapshotEvent() {
        UUID aggregateIdentifier = UUID.randomUUID();
        StubAggregate aggregate = new StubAggregate(aggregateIdentifier);
        GenericDomainEventMessage first = new GenericDomainEventMessage("type", aggregate.getIdentifier(), 0L, (Object)aggregate);
        GenericDomainEventMessage second = new GenericDomainEventMessage("type", aggregateIdentifier.toString(), 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        DomainEventStream eventStream = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{first, second});
        Mockito.when((Object)this.mockAggregateFactory.createAggregateRoot((String)Mockito.any(), (DomainEventMessage)Mockito.any(DomainEventMessage.class))).thenAnswer(invocation -> ((DomainEventMessage)invocation.getArguments()[1]).getPayload());
        DomainEventMessage snapshot = this.testSubject.createSnapshot(StubAggregate.class, aggregateIdentifier.toString(), eventStream);
        Assertions.assertSame((Object)aggregate, (Object)snapshot.getPayload(), (String)"Snapshotter did not recognize the aggregate snapshot");
        ((AggregateFactory)Mockito.verify((Object)this.mockAggregateFactory)).createAggregateRoot((String)Mockito.any(), (DomainEventMessage)Mockito.any(DomainEventMessage.class));
    }

    @Test
    void createSnapshot_AggregateMarkedDeletedWillNotGenerateSnapshot() {
        String aggregateIdentifier = UUID.randomUUID().toString();
        GenericDomainEventMessage firstEvent = new GenericDomainEventMessage("type", aggregateIdentifier, 0L, (Object)"Mock contents", (Map)MetaData.emptyInstance());
        GenericDomainEventMessage secondEvent = new GenericDomainEventMessage("type", aggregateIdentifier, 0L, (Object)"deleted", (Map)MetaData.emptyInstance());
        DomainEventStream eventStream = DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{firstEvent, secondEvent});
        StubAggregate aggregate = new StubAggregate(aggregateIdentifier);
        Mockito.when((Object)this.mockAggregateFactory.createAggregateRoot(aggregateIdentifier, (DomainEventMessage)firstEvent)).thenReturn((Object)aggregate);
        DomainEventMessage snapshot = this.testSubject.createSnapshot(StubAggregate.class, aggregateIdentifier, eventStream);
        ((AggregateFactory)Mockito.verify((Object)this.mockAggregateFactory)).createAggregateRoot(aggregateIdentifier, (DomainEventMessage)firstEvent);
        Assertions.assertNull((Object)snapshot, (String)"Snapshotter shouldn't have created snapshot of deleted aggregate");
    }

    public static class StubAggregate {
        @AggregateIdentifier
        private String identifier;

        public StubAggregate() {
            this.identifier = UUID.randomUUID().toString();
        }

        public StubAggregate(Object identifier) {
            this.identifier = identifier.toString();
        }

        public void doSomething() {
            AggregateLifecycle.apply((Object)new StubDomainEvent());
        }

        public String getIdentifier() {
            return this.identifier;
        }

        @EventSourcingHandler
        protected void handle(EventMessage event) {
            this.identifier = ((DomainEventMessage)event).getAggregateIdentifier();
            if ("Mock contents".equals(event.getPayload().toString())) {
                AggregateLifecycle.apply((Object)"Another");
            }
            if ("deleted".equals(event.getPayload().toString())) {
                AggregateLifecycle.markDeleted();
            }
        }
    }
}

