/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.ArrayList;
import java.util.HashMap;
import org.axonframework.common.caching.Cache;
import org.axonframework.common.caching.EhCache3Adapter;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.AggregateDeletedException;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.CachingEventSourcingRepository;
import org.axonframework.eventsourcing.EventSourcedAggregate;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.eventsourcing.utils.MockException;
import org.axonframework.eventsourcing.utils.StubAggregate;
import org.axonframework.messaging.unitofwork.CurrentUnitOfWork;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.messaging.unitofwork.UnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.modelling.command.AggregateLifecycle;
import org.axonframework.modelling.command.LockAwareAggregate;
import org.ehcache.CacheManager;
import org.ehcache.config.Configuration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.core.Ehcache;
import org.ehcache.core.EhcacheManager;
import org.ehcache.core.config.DefaultConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class CachingEventSourcingRepositoryTest {
    private CachingEventSourcingRepository<StubAggregate> testSubject;
    private EventStore mockEventStore;
    private Cache cache;
    private Ehcache ehCache;
    private CacheManager cacheManager;

    CachingEventSourcingRepositoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockEventStore = (EventStore)Mockito.spy((Object)EmbeddedEventStore.builder().storageEngine((EventStorageEngine)new InMemoryEventStorageEngine()).build());
        HashMap caches = new HashMap();
        DefaultConfiguration config = new DefaultConfiguration(caches, null, new ServiceCreationConfiguration[0]);
        this.cacheManager = new EhcacheManager((Configuration)config);
        this.cacheManager.init();
        this.ehCache = (Ehcache)this.cacheManager.createCache("testCache", CacheConfigurationBuilder.newCacheConfigurationBuilder(Object.class, Object.class, (ResourcePools)ResourcePoolsBuilder.heap((long)100L).build()).build());
        this.cache = (Cache)Mockito.spy((Object)new EhCache3Adapter(this.ehCache));
        this.testSubject = (CachingEventSourcingRepository)CachingEventSourcingRepository.builder(StubAggregate.class).aggregateFactory((AggregateFactory)new StubAggregateFactory()).eventStore(this.mockEventStore).cache(this.cache).build();
    }

    @AfterEach
    void tearDown() {
        while (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().rollback();
        }
        this.cacheManager.close();
    }

    @Test
    void aggregatesRetrievedFromCache() throws Exception {
        this.startAndGetUnitOfWork();
        LockAwareAggregate aggregate1 = (LockAwareAggregate)this.testSubject.newInstance(() -> new StubAggregate("aggregateId"));
        aggregate1.execute(StubAggregate::doSomething);
        Assertions.assertEquals((long)0L, (Long)((EventSourcedAggregate)aggregate1.getWrappedAggregate()).lastSequence());
        CurrentUnitOfWork.commit();
        this.startAndGetUnitOfWork();
        LockAwareAggregate reloadedAggregate1 = (LockAwareAggregate)this.testSubject.load("aggregateId", null);
        Assertions.assertEquals((long)0L, (Long)((EventSourcedAggregate)reloadedAggregate1.getWrappedAggregate()).lastSequence());
        aggregate1.execute(StubAggregate::doSomething);
        aggregate1.execute(StubAggregate::doSomething);
        Assertions.assertEquals((long)2L, (Long)((EventSourcedAggregate)aggregate1.getWrappedAggregate()).lastSequence());
        CurrentUnitOfWork.commit();
        DefaultUnitOfWork.startAndGet(null);
        DomainEventStream events = this.mockEventStore.readEvents("aggregateId");
        ArrayList<DomainEventMessage> eventList = new ArrayList<DomainEventMessage>();
        while (events.hasNext()) {
            eventList.add(events.next());
        }
        Assertions.assertEquals((int)3, (int)eventList.size());
        this.ehCache.clear();
        reloadedAggregate1 = (LockAwareAggregate)this.testSubject.load(aggregate1.identifierAsString(), null);
        Assertions.assertNotSame((Object)aggregate1.getWrappedAggregate(), (Object)reloadedAggregate1.getWrappedAggregate());
        Assertions.assertEquals((Long)aggregate1.version(), (Long)reloadedAggregate1.version());
        Assertions.assertEquals((long)2L, (Long)((EventSourcedAggregate)reloadedAggregate1.getWrappedAggregate()).lastSequence());
    }

    @Test
    void loadOrCreateNewAggregate() {
        this.startAndGetUnitOfWork();
        Aggregate aggregate = this.testSubject.loadOrCreate("id1", StubAggregate::new);
        aggregate.execute(s -> s.setIdentifier("id1"));
        CurrentUnitOfWork.commit();
        Assertions.assertNotNull((Object)this.cache.get((Object)"id1"));
        ((Cache)Mockito.verify((Object)this.cache, (VerificationMode)Mockito.never())).put(Mockito.isNull(), Mockito.any());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void loadDeletedAggregate() throws Exception {
        String identifier = "aggregateId";
        this.startAndGetUnitOfWork();
        Aggregate aggregate1 = this.testSubject.newInstance(() -> new StubAggregate(identifier));
        CurrentUnitOfWork.commit();
        this.startAndGetUnitOfWork();
        ((LockAwareAggregate)this.testSubject.load(identifier)).execute(r -> AggregateLifecycle.markDeleted());
        CurrentUnitOfWork.commit();
        this.startAndGetUnitOfWork();
        try {
            this.testSubject.load(identifier);
            Assertions.fail((String)"Expected AggregateDeletedException");
        }
        catch (AggregateDeletedException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(identifier));
        }
        finally {
            CurrentUnitOfWork.commit();
        }
    }

    @Test
    void cacheClearedAfterRollbackOfAddedAggregate() throws Exception {
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        uow.onCommit(c -> {
            throw new MockException();
        });
        try {
            ((LockAwareAggregate)this.testSubject.newInstance(() -> new StubAggregate("id1"))).execute(StubAggregate::doSomething);
            uow.commit();
        }
        catch (MockException mockException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.cache.get((Object)"id1"));
    }

    @Test
    void cacheClearedAfterRollbackOfLoadedAggregate() {
        this.startAndGetUnitOfWork().executeWithResult(() -> (LockAwareAggregate)this.testSubject.newInstance(() -> new StubAggregate("id1")));
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        uow.onCommit(c -> {
            throw new MockException();
        });
        try {
            ((LockAwareAggregate)this.testSubject.load("id1")).execute(StubAggregate::doSomething);
            uow.commit();
        }
        catch (MockException mockException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.cache.get((Object)"id1"));
    }

    @Test
    void cacheClearedAfterRollbackOfLoadedAggregateUsingLoadOrCreate() throws Exception {
        this.startAndGetUnitOfWork().executeWithResult(() -> (LockAwareAggregate)this.testSubject.newInstance(() -> new StubAggregate("id1")));
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        uow.onCommit(c -> {
            throw new MockException();
        });
        try {
            this.testSubject.loadOrCreate("id1", () -> new StubAggregate("id1")).execute(StubAggregate::doSomething);
            uow.commit();
        }
        catch (MockException mockException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.cache.get((Object)"id1"));
    }

    @Test
    void cacheClearedAfterRollbackOfCreatedAggregateUsingLoadOrCreate() throws Exception {
        UnitOfWork<?> uow = this.startAndGetUnitOfWork();
        uow.onCommit(c -> {
            throw new MockException();
        });
        try {
            this.testSubject.loadOrCreate("id1", () -> new StubAggregate("id1")).execute(StubAggregate::doSomething);
            uow.commit();
        }
        catch (MockException mockException) {
            // empty catch block
        }
        Assertions.assertNull((Object)this.cache.get((Object)"id1"));
    }

    private UnitOfWork<?> startAndGetUnitOfWork() {
        return DefaultUnitOfWork.startAndGet(null);
    }

    private static class StubAggregateFactory
    extends AbstractAggregateFactory<StubAggregate> {
        public StubAggregateFactory() {
            super(StubAggregate.class);
        }

        public StubAggregate doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
            return new StubAggregate();
        }

        public Class<StubAggregate> getAggregateType() {
            return StubAggregate.class;
        }
    }
}

