/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import org.axonframework.eventsourcing.DefaultSnapshotterSpanFactory;
import org.axonframework.tracing.IntermediateSpanFactoryTest;
import org.axonframework.tracing.SpanFactory;
import org.axonframework.tracing.TestSpanFactory;
import org.junit.jupiter.api.Test;

class DefaultSnapshotterSpanFactoryTest
extends IntermediateSpanFactoryTest<DefaultSnapshotterSpanFactory.Builder, DefaultSnapshotterSpanFactory> {
    DefaultSnapshotterSpanFactoryTest() {
    }

    @Test
    void createScheduleSnapshotSpanWithDefaults() {
        this.test(spanFactory -> spanFactory.createScheduleSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.scheduleSnapshot(MyAggregateType)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    @Test
    void scheduleSnapshotSpanIncludesAggregateName() {
        this.test(builder -> builder.aggregateTypeInSpanName(true).separateTrace(false), spanFactory -> spanFactory.createScheduleSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.scheduleSnapshot(MyAggregateType)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    @Test
    void scheduleSnapshotSpanDoesntIncludeAggregateName() {
        this.test(builder -> builder.aggregateTypeInSpanName(false).separateTrace(false), spanFactory -> spanFactory.createScheduleSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.scheduleSnapshot", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    @Test
    void scheduleSnapshotSpanIsNotAffectedBySeparateTrace() {
        this.test(builder -> builder.aggregateTypeInSpanName(false).separateTrace(true), spanFactory -> spanFactory.createScheduleSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.scheduleSnapshot", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    @Test
    void createSnapshotSpanWithDefaults() {
        this.test(spanFactory -> spanFactory.createCreateSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.createSnapshot(MyAggregateType)", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    @Test
    void createSnapshotSpanWithSeparateTraceAndWithoutAggregateInSpanName() {
        this.test(builder -> builder.aggregateTypeInSpanName(false).separateTrace(true), spanFactory -> spanFactory.createCreateSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.createSnapshot", TestSpanFactory.TestSpanType.ROOT).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    @Test
    void createSnapshotSpanWithInnerTraceAndWithoutAggregateInSpanName() {
        this.test(builder -> builder.aggregateTypeInSpanName(false).separateTrace(false), spanFactory -> spanFactory.createCreateSnapshotSpan("MyAggregateType", "3728973982"), this.expectedSpan("Snapshotter.createSnapshot", TestSpanFactory.TestSpanType.INTERNAL).expectAttribute("aggregateIdentifier", "3728973982"));
    }

    protected DefaultSnapshotterSpanFactory.Builder createBuilder(SpanFactory spanFactory) {
        return DefaultSnapshotterSpanFactory.builder().spanFactory(spanFactory);
    }

    protected DefaultSnapshotterSpanFactory createFactoryBasedOnBuilder(DefaultSnapshotterSpanFactory.Builder builder) {
        return builder.build();
    }
}

