/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.time.Instant;
import java.util.Objects;
import java.util.stream.Stream;
import org.axonframework.common.IdentifierFactory;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.GenericDomainEventEntry;
import org.axonframework.eventsourcing.EventStreamUtils;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.upcasting.event.EventUpcaster;
import org.axonframework.serialization.upcasting.event.EventUpcasterChain;
import org.axonframework.serialization.upcasting.event.NoOpEventUpcaster;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class EventStreamUtilsTest {
    private Serializer serializer;

    EventStreamUtilsTest() {
    }

    @BeforeEach
    void setUp() {
        this.serializer = (Serializer)Mockito.mock(Serializer.class);
    }

    @Test
    void domainEventStream_lastSequenceNumberEqualToLastProcessedEntry() {
        DomainEventStream eventStream = EventStreamUtils.upcastAndDeserializeDomainEvents(Stream.of(EventStreamUtilsTest.createEntry(1L)), (Serializer)this.serializer, (EventUpcaster)NoOpEventUpcaster.INSTANCE);
        Assertions.assertNull((Object)eventStream.getLastSequenceNumber());
        eventStream.forEachRemaining(Objects::requireNonNull);
        Assertions.assertEquals((Long)1L, (Long)eventStream.getLastSequenceNumber());
    }

    @Test
    void domainEventStream_lastSequenceNumberEqualToLastProcessedEntryAfterIgnoringLastEntry() {
        DomainEventStream eventStream = EventStreamUtils.upcastAndDeserializeDomainEvents(Stream.of(EventStreamUtilsTest.createEntry(1L), EventStreamUtilsTest.createEntry(2L), EventStreamUtilsTest.createEntry(3L)), (Serializer)this.serializer, (EventUpcaster)new EventUpcasterChain(new EventUpcaster[]{e -> e.filter(entry -> (Long)entry.getSequenceNumber().get() < 2L)}));
        Assertions.assertNull((Object)eventStream.getLastSequenceNumber());
        Assertions.assertTrue((boolean)eventStream.hasNext());
        eventStream.forEachRemaining(Objects::requireNonNull);
        Assertions.assertEquals((Long)3L, (Long)eventStream.getLastSequenceNumber());
    }

    @Test
    void domainEventStream_lastSequenceNumberEqualToLastProcessedEntryAfterUpcastingToEmptyStream() {
        DomainEventStream eventStream = EventStreamUtils.upcastAndDeserializeDomainEvents(Stream.of(EventStreamUtilsTest.createEntry(1L)), (Serializer)this.serializer, (EventUpcaster)new EventUpcasterChain(new EventUpcaster[]{s -> s.filter(e -> false)}));
        Assertions.assertNull((Object)eventStream.getLastSequenceNumber());
        Assertions.assertFalse((boolean)eventStream.hasNext());
        eventStream.forEachRemaining(Objects::requireNonNull);
        Assertions.assertEquals((Long)1L, (Long)eventStream.getLastSequenceNumber());
    }

    @Test
    void domainEventStream_nullPointerExceptionOnEmptyEventStream() {
        DomainEventStream eventStream = EventStreamUtils.upcastAndDeserializeDomainEvents(Stream.empty(), (Serializer)this.serializer, (EventUpcaster)NoOpEventUpcaster.INSTANCE);
        Assertions.assertNull((Object)eventStream.getLastSequenceNumber());
    }

    private static DomainEventData<?> createEntry(long sequenceNumber) {
        return new GenericDomainEventEntry("type", "testAggregate", sequenceNumber, IdentifierFactory.getInstance().generateIdentifier(), (Object)Instant.now(), String.class.getName(), null, (Object)"test", (Object)"metadata");
    }
}

