/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.UUID;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.GenericAggregateFactory;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.axonframework.eventsourcing.utils.MockException;
import org.axonframework.eventsourcing.utils.StubAggregate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class GenericAggregateFactoryTest {
    GenericAggregateFactoryTest() {
    }

    @Test
    void initializeRepository_NoSuitableConstructor() {
        Assertions.assertThrows(IncompatibleAggregateException.class, () -> new GenericAggregateFactory(UnsuitableAggregate.class));
    }

    @Test
    void initializeRepository_ConstructorNotCallable() {
        GenericAggregateFactory factory = new GenericAggregateFactory(ExceptionThrowingAggregate.class);
        try {
            factory.createAggregateRoot(UUID.randomUUID().toString(), (DomainEventMessage)new GenericDomainEventMessage("type", "", 0L, new Object()));
            Assertions.fail((String)"Expected IncompatibleAggregateException");
        }
        catch (IncompatibleAggregateException incompatibleAggregateException) {
            // empty catch block
        }
    }

    @Test
    void initializeFromAggregateSnapshot() {
        StubAggregate aggregate = new StubAggregate("stubId");
        GenericDomainEventMessage snapshotMessage = new GenericDomainEventMessage("type", aggregate.getIdentifier(), 2L, (Object)aggregate);
        GenericAggregateFactory factory = new GenericAggregateFactory(StubAggregate.class);
        Assertions.assertSame((Object)aggregate, (Object)factory.createAggregateRoot(aggregate.getIdentifier(), (DomainEventMessage)snapshotMessage));
    }

    @Test
    void initializeFromAggregateSnapshot_AvoidCallingDoCreateAggregate() {
        StubAggregate aggregate = new StubAggregate("stubId");
        GenericDomainEventMessage snapshotMessage = new GenericDomainEventMessage("type", aggregate.getIdentifier(), 2L, (Object)aggregate);
        RogueAggregateFactory factory = new RogueAggregateFactory(StubAggregate.class);
        Assertions.assertSame((Object)aggregate, (Object)factory.createAggregateRoot(aggregate.getIdentifier(), (DomainEventMessage)snapshotMessage));
    }

    private static class RogueAggregateFactory
    extends GenericAggregateFactory<StubAggregate> {
        public RogueAggregateFactory(Class<StubAggregate> aggregateType) {
            super(aggregateType);
        }

        protected StubAggregate doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
            throw new AssertionError((Object)"Forced error");
        }
    }

    private static class ExceptionThrowingAggregate {
        private ExceptionThrowingAggregate() {
            throw new MockException();
        }
    }

    private static class UnsuitableAggregate {
        private UnsuitableAggregate(Object uuid) {
        }
    }
}

