/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.conflictresolution;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.conflictresolution.Conflicts;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ConflictsTest {
    private final List<DomainEventMessage<?>> events = IntStream.range(0, 10).mapToObj(sequenceNumber -> EventStoreTestUtils.createEvent("aggregate", sequenceNumber, "payload" + sequenceNumber)).collect(Collectors.toList());

    ConflictsTest() {
    }

    @Test
    void payload() {
        Assertions.assertTrue((boolean)Conflicts.payloadMatching(payload -> Objects.equals(payload, "payload2")).test(this.events));
        Assertions.assertTrue((boolean)Conflicts.payloadMatching(String.class, payload -> Objects.equals(payload, "payload5")).test(this.events));
        Assertions.assertFalse((boolean)Conflicts.payloadMatching(payload -> Objects.equals(payload, "payload11")).test(this.events));
    }

    @Test
    void payloadType() {
        Assertions.assertTrue((boolean)Conflicts.payloadTypeOf(String.class).test(this.events));
        Assertions.assertTrue((boolean)Conflicts.payloadTypeOf(Object.class).test(this.events));
        Assertions.assertFalse((boolean)Conflicts.payloadTypeOf(Long.class).test(this.events));
    }
}

