/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.conflictresolution;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.axonframework.eventsourcing.conflictresolution.Conflicts;
import org.axonframework.eventsourcing.conflictresolution.DefaultConflictResolver;
import org.axonframework.eventsourcing.eventstore.EmbeddedEventStore;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.EventStore;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.axonframework.modelling.command.ConflictingModificationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class DefaultConflictResolverTest {
    private EventStore eventStore;
    private DefaultConflictResolver subject;

    DefaultConflictResolverTest() {
    }

    @BeforeEach
    void setUp() {
        this.eventStore = (EventStore)Mockito.spy((Object)EmbeddedEventStore.builder().storageEngine((EventStorageEngine)new InMemoryEventStorageEngine()).build());
        this.eventStore.publish(IntStream.range(0, 10).mapToObj(sequenceNumber -> EventStoreTestUtils.createEvent("aggregate", sequenceNumber, "payload" + sequenceNumber)).collect(Collectors.toList()));
    }

    @Test
    void detectConflicts() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 9L);
        Assertions.assertThrows(ConflictingModificationException.class, () -> this.subject.detectConflicts(Conflicts.payloadTypeOf(String.class)));
    }

    @Test
    void detectNoConflictsWhenPredicateDoesNotMatch() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 9L);
        this.subject.detectConflicts(Conflicts.payloadTypeOf(Long.class));
    }

    @Test
    void detectNoConflictsWithoutUnseenEvents() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 5L);
        this.subject.detectConflicts(Conflicts.payloadTypeOf(String.class));
    }

    @Test
    void ensureConflictsResolvedThrowsExceptionWithoutRegisteredConflicts() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 9L);
        Assertions.assertThrows(ConflictingModificationException.class, () -> ((DefaultConflictResolver)this.subject).ensureConflictsResolved());
    }

    @Test
    void ensureConflictsResolvedDoesNothingWithRegisteredConflicts() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 9L);
        this.subject.detectConflicts(Conflicts.payloadMatching(Long.class::isInstance));
        this.subject.ensureConflictsResolved();
    }

    @Test
    void conflictingEventsAreAvailableInExceptionBuilder() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 9L);
        try {
            this.subject.detectConflicts(Conflicts.payloadTypeOf(String.class), c -> new ConflictingModificationException("" + c.unexpectedEvents().size()));
            Assertions.fail((String)"Expected exception");
        }
        catch (ConflictingModificationException e) {
            Assertions.assertEquals((Object)"4", (Object)e.getMessage());
        }
    }

    @Test
    void conflictResolverProvidingNullExceptionIgnoresConflict() {
        this.subject = new DefaultConflictResolver(this.eventStore, "aggregate", 5L, 9L);
        this.subject.detectConflicts(Conflicts.payloadTypeOf(String.class), c -> null);
    }
}

