/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.Optional;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventsourcing.eventstore.AbstractEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.AbstractEventStorageEngineTest;
import org.axonframework.eventsourcing.eventstore.BatchingEventStorageEngine;
import org.axonframework.eventsourcing.utils.EventStoreTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class BatchingEventStorageEngineTest<E extends BatchingEventStorageEngine, EB extends BatchingEventStorageEngine.Builder>
extends AbstractEventStorageEngineTest<E, EB> {
    private BatchingEventStorageEngine testSubject;

    @Test
    protected void loadLargeAmountOfEventsFromAggregateStream() {
        int eventCount = this.testSubject.batchSize() + 10;
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(eventCount));
        this.testSubject.appendEvents(new EventMessage[]{new GenericEventMessage((Object)"test")});
        Assertions.assertEquals((long)eventCount, (long)this.testSubject.readEvents("aggregate").asStream().count());
        Optional resultEventMessage = this.testSubject.readEvents("aggregate").asStream().reduce((a, b) -> b);
        Assertions.assertTrue((boolean)resultEventMessage.isPresent());
        Assertions.assertEquals((long)(eventCount - 1), (long)((DomainEventMessage)resultEventMessage.get()).getSequenceNumber());
    }

    @Test
    void loadLargeAmountFromOpenStream() {
        int eventCount = this.testSubject.batchSize() + 10;
        this.testSubject.appendEvents(EventStoreTestUtils.createEvents(eventCount));
        GenericEventMessage last = new GenericEventMessage((Object)"test");
        this.testSubject.appendEvents(new EventMessage[]{last});
        Optional resultEventMessage = this.testSubject.readEvents(null, false).reduce((a, b) -> b);
        Assertions.assertEquals((long)(this.testSubject.batchSize() + 11), (long)this.testSubject.readEvents(null, false).count());
        Assertions.assertTrue((boolean)resultEventMessage.isPresent());
        Assertions.assertEquals((Object)last.getIdentifier(), (Object)((EventMessage)resultEventMessage.get()).getIdentifier());
    }

    protected void setTestSubject(BatchingEventStorageEngine testSubject) {
        this.testSubject = testSubject;
        super.setTestSubject((AbstractEventStorageEngine)this.testSubject);
    }
}

