/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.FilteringDomainEventStream;
import org.axonframework.messaging.MetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class FilteringDomainEventStreamTest {
    private DomainEventMessage event1;
    private DomainEventMessage event2;
    private DomainEventMessage event3;

    FilteringDomainEventStreamTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.event1 = new GenericDomainEventMessage("type", "1", 0L, (Object)"Create type 1", (Map)MetaData.emptyInstance());
        this.event2 = new GenericDomainEventMessage("type2", "1", 0L, (Object)"Create type 2", (Map)MetaData.emptyInstance());
        this.event3 = new GenericDomainEventMessage("type2", "1", 1L, (Object)"Change type 2", (Map)MetaData.emptyInstance());
    }

    @Test
    void forEachRemainingType1() {
        List<DomainEventMessage> expectedMessages = Arrays.asList(this.event1);
        FilteringDomainEventStream concat = new FilteringDomainEventStream(DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event2, this.event3}), e -> e.getType().equals("type"));
        ArrayList actualMessages = new ArrayList();
        concat.forEachRemaining(actualMessages::add);
        Assertions.assertEquals(expectedMessages, actualMessages);
    }

    @Test
    void forEachRemainingType2() {
        List<DomainEventMessage> expectedMessages = Arrays.asList(this.event2, this.event3);
        FilteringDomainEventStream concat = new FilteringDomainEventStream(DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{this.event1, this.event2, this.event3}), e -> e.getType().equals("type2"));
        ArrayList actualMessages = new ArrayList();
        concat.forEachRemaining(actualMessages::add);
        Assertions.assertEquals(expectedMessages, actualMessages);
    }
}

