/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.eventhandling.GenericDomainEventMessage;
import org.axonframework.eventhandling.GenericEventMessage;
import org.axonframework.eventhandling.GenericTrackedDomainEventMessage;
import org.axonframework.eventhandling.GlobalSequenceTrackingToken;
import org.axonframework.eventhandling.TrackedEventMessage;
import org.axonframework.eventhandling.TrackingToken;
import org.axonframework.eventsourcing.eventstore.DomainEventStream;
import org.axonframework.eventsourcing.eventstore.EventStorageEngine;
import org.axonframework.eventsourcing.eventstore.SequenceEventStorageEngine;
import org.axonframework.eventsourcing.eventstore.inmemory.InMemoryEventStorageEngine;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class SequenceEventStorageEngineTest {
    private EventStorageEngine activeStorage;
    private EventStorageEngine historicStorage;
    private SequenceEventStorageEngine testSubject;

    SequenceEventStorageEngineTest() {
    }

    @BeforeEach
    void setUp() {
        this.activeStorage = (EventStorageEngine)Mockito.mock(EventStorageEngine.class, (String)"activeStorage");
        this.historicStorage = (EventStorageEngine)Mockito.mock(EventStorageEngine.class, (String)"historicStorage");
        this.testSubject = new SequenceEventStorageEngine(this.historicStorage, this.activeStorage);
        Mockito.when((Object)this.historicStorage.readSnapshot(Mockito.anyString())).thenReturn(Optional.empty());
        Mockito.when((Object)this.activeStorage.readSnapshot(Mockito.anyString())).thenReturn(Optional.empty());
    }

    @Test
    void publishEventsSendsToActiveStorageOnly() {
        List<EventMessage> events = Collections.singletonList(GenericEventMessage.asEventMessage((Object)"test"));
        this.testSubject.appendEvents(events);
        ((EventStorageEngine)Mockito.verify((Object)this.historicStorage, (VerificationMode)Mockito.never())).appendEvents(Mockito.anyList());
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage)).appendEvents(events);
    }

    @Test
    void aggregateEventsAreReadFromHistoricThenActive() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.of((DomainEventMessage)event1));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.of((DomainEventMessage)event2));
        DomainEventStream actual = this.testSubject.readEvents("aggregate", 0L);
        Assertions.assertEquals((long)0L, (long)actual.getLastSequenceNumber());
        Assertions.assertTrue((boolean)actual.hasNext());
        Assertions.assertSame((Object)event1, (Object)actual.peek());
        Assertions.assertSame((Object)event1, (Object)actual.next());
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertTrue((boolean)actual.hasNext());
        Assertions.assertSame((Object)event2, (Object)actual.peek());
        Assertions.assertSame((Object)event2, (Object)actual.next());
        Assertions.assertEquals((long)1L, (long)actual.getLastSequenceNumber());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readEvents("aggregate", 0L);
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readEvents("aggregate", 1L);
        Assertions.assertFalse((boolean)actual.hasNext());
    }

    @Test
    void aggregateEventsAreReadFromActiveWhenNoHistoricEventsAvailable() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.empty());
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2}));
        DomainEventStream actual = this.testSubject.readEvents("aggregate", 0L);
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertSame((Object)event1, (Object)actual.peek());
        Assertions.assertSame((Object)event1, (Object)actual.next());
        Assertions.assertSame((Object)event2, (Object)actual.peek());
        Assertions.assertSame((Object)event2, (Object)actual.next());
        Long seq = actual.getLastSequenceNumber();
        Assertions.assertNotNull((Object)seq);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readEvents("aggregate", 0L);
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readEvents("aggregate", 0L);
        Assertions.assertFalse((boolean)actual.hasNext());
    }

    @Test
    void aggregateEventsAreReadFromHistoricWhenNoActiveEventsAvailable() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, event2}));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.empty());
        DomainEventStream actual = this.testSubject.readEvents("aggregate", 0L);
        Assertions.assertEquals((long)1L, (long)actual.getLastSequenceNumber());
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertSame((Object)event1, (Object)actual.peek());
        Assertions.assertSame((Object)event1, (Object)actual.next());
        Assertions.assertSame((Object)event2, (Object)actual.peek());
        Assertions.assertSame((Object)event2, (Object)actual.next());
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertFalse((boolean)actual.hasNext());
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage)).readEvents("aggregate", 2L);
        Assertions.assertEquals((long)1L, (long)actual.getLastSequenceNumber());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readEvents("aggregate", 0L);
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readEvents("aggregate", 2L);
        Assertions.assertFalse((boolean)actual.hasNext());
    }

    @Test
    void snapshotsStoredInActiveStorage() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        this.testSubject.storeSnapshot((DomainEventMessage)event1);
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage)).storeSnapshot((DomainEventMessage)event1);
        ((EventStorageEngine)Mockito.verify((Object)this.historicStorage, (VerificationMode)Mockito.never())).storeSnapshot((DomainEventMessage)Mockito.any());
    }

    @Test
    void eventStreamedFromHistoricThenActive() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        GlobalSequenceTrackingToken token1 = new GlobalSequenceTrackingToken(1L);
        GlobalSequenceTrackingToken token2 = new GlobalSequenceTrackingToken(2L);
        GenericTrackedDomainEventMessage trackedEvent1 = new GenericTrackedDomainEventMessage((TrackingToken)token1, (DomainEventMessage)event1);
        GenericTrackedDomainEventMessage trackedEvent2 = new GenericTrackedDomainEventMessage((TrackingToken)token2, (DomainEventMessage)event2);
        ((EventStorageEngine)Mockito.doReturn(Stream.of(trackedEvent1)).when((Object)this.historicStorage)).readEvents((TrackingToken)Mockito.any(TrackingToken.class), Mockito.anyBoolean());
        ((EventStorageEngine)Mockito.doReturn(Stream.of(trackedEvent2)).when((Object)this.activeStorage)).readEvents((TrackingToken)Mockito.any(TrackingToken.class), Mockito.anyBoolean());
        GlobalSequenceTrackingToken startToken = new GlobalSequenceTrackingToken(0L);
        Stream actual = this.testSubject.readEvents((TrackingToken)startToken, true);
        List actualList = actual.collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)actualList.size());
        Assertions.assertEquals(Arrays.asList(trackedEvent1, trackedEvent2), actualList);
        ((EventStorageEngine)Mockito.verify((Object)this.historicStorage)).readEvents((TrackingToken)startToken, true);
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage)).readEvents((TrackingToken)token1, true);
    }

    @Test
    void snapshotReadFromActiveThenHistoric() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        Mockito.when((Object)this.historicStorage.readSnapshot("aggregate")).thenReturn(Optional.of(event1));
        Mockito.when((Object)this.activeStorage.readSnapshot("aggregate")).thenReturn(Optional.empty());
        Optional actual = this.testSubject.readSnapshot("aggregate");
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertSame((Object)event1, actual.get());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readSnapshot("aggregate");
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readSnapshot("aggregate");
    }

    @Test
    void snapshotReadFromActive() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        Mockito.when((Object)this.historicStorage.readSnapshot("aggregate")).thenReturn(Optional.of(event2));
        Mockito.when((Object)this.activeStorage.readSnapshot("aggregate")).thenReturn(Optional.of(event1));
        Optional actual = this.testSubject.readSnapshot("aggregate");
        Assertions.assertTrue((boolean)actual.isPresent());
        Assertions.assertSame((Object)event1, actual.get());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readSnapshot("aggregate");
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void createTailToken() {
        this.testSubject.createTailToken();
        ((EventStorageEngine)Mockito.verify((Object)this.historicStorage)).createTailToken();
    }

    @Test
    void createHeadToken() {
        this.testSubject.createHeadToken();
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage)).createHeadToken();
    }

    @Test
    void createTokenAtWhenIsPresentInActiveStorage() {
        Instant now = Instant.now();
        GlobalSequenceTrackingToken mockTrackingToken = new GlobalSequenceTrackingToken(3L);
        Mockito.when((Object)this.activeStorage.createTokenAt(now)).thenReturn((Object)mockTrackingToken);
        TrackingToken tokenAt = this.testSubject.createTokenAt(now);
        Assertions.assertEquals((Object)mockTrackingToken, (Object)tokenAt);
        ((EventStorageEngine)Mockito.verify((Object)this.historicStorage, (VerificationMode)Mockito.times((int)0))).createTokenAt(now);
    }

    @Test
    void createTokenAtWhenIsNotPresentInActiveStorage() {
        Instant now = Instant.now();
        GlobalSequenceTrackingToken mockTrackingToken = new GlobalSequenceTrackingToken(3L);
        Mockito.when((Object)this.activeStorage.createTokenAt(now)).thenReturn(null);
        Mockito.when((Object)this.historicStorage.createTokenAt(now)).thenReturn((Object)mockTrackingToken);
        TrackingToken tokenAt = this.testSubject.createTokenAt(now);
        Assertions.assertEquals((Object)mockTrackingToken, (Object)tokenAt);
    }

    @Test
    void streamFromPositionInActiveStorage() {
        this.historicStorage = new InMemoryEventStorageEngine();
        this.activeStorage = new InMemoryEventStorageEngine(1L);
        this.testSubject = new SequenceEventStorageEngine(this.historicStorage, this.activeStorage);
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage event2 = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        GenericDomainEventMessage event3 = new GenericDomainEventMessage("type", "aggregate", 2L, (Object)"test3");
        this.historicStorage.appendEvents(new EventMessage[]{event1});
        this.activeStorage.appendEvents(new EventMessage[]{event2, event3});
        Stream stream = this.testSubject.readEvents(null, true);
        TrackedEventMessage firstEvent = (TrackedEventMessage)stream.findFirst().orElseThrow(IllegalStateException::new);
        Assertions.assertEquals((Object)"test1", (Object)firstEvent.getPayload());
        Stream stream2 = this.testSubject.readEvents(firstEvent.trackingToken(), true);
        List secondBatch = stream2.collect(Collectors.toList());
        Assertions.assertEquals((int)2, (int)secondBatch.size());
        Assertions.assertEquals((Object)"test2", (Object)((TrackedEventMessage)secondBatch.get(0)).getPayload());
        Assertions.assertEquals((Object)"test3", (Object)((TrackedEventMessage)secondBatch.get(1)).getPayload());
        Stream stream3 = this.testSubject.readEvents(((TrackedEventMessage)secondBatch.get(0)).trackingToken(), true);
        List thirdBatch = stream3.collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)thirdBatch.size());
        Assertions.assertEquals((Object)"test3", (Object)((TrackedEventMessage)thirdBatch.get(0)).getPayload());
        Stream stream4 = this.testSubject.readEvents(((TrackedEventMessage)secondBatch.get(1)).trackingToken(), true);
        Assertions.assertFalse((boolean)stream4.findFirst().isPresent());
    }

    @Test
    void aggregateEventsAreReadFromFirstSequenceNumber() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        GenericDomainEventMessage event3 = new GenericDomainEventMessage("type", "aggregate", 2L, (Object)"test3");
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)0L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage)event1));
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.longThat(l -> l > 0L))).thenReturn((Object)DomainEventStream.empty());
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.longThat(l -> l < 2L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{snapshotEvent, event3}));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)2L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage)event3));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.longThat(l -> l > 2L))).thenReturn((Object)DomainEventStream.empty());
        DomainEventStream actual = this.testSubject.readEvents("aggregate", 2L);
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertTrue((boolean)actual.hasNext());
        Assertions.assertSame((Object)event3, (Object)actual.peek());
        Assertions.assertSame((Object)event3, (Object)actual.next());
        Assertions.assertEquals((long)2L, (long)actual.getLastSequenceNumber());
        Assertions.assertFalse((boolean)actual.hasNext());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readEvents("aggregate", 2L);
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readEvents("aggregate", 2L);
    }

    @Test
    void aggregateEventsAreReadFromFirstSequenceNumberHistoricOnly() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test2");
        GenericDomainEventMessage event3 = new GenericDomainEventMessage("type", "aggregate", 2L, (Object)"test3");
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)0L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, snapshotEvent, event3}));
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)1L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{snapshotEvent, event3}));
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)2L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage)event3));
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.longThat(l -> l > 2L))).thenReturn((Object)DomainEventStream.empty());
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.empty());
        DomainEventStream actual = this.testSubject.readEvents("aggregate", 2L);
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertTrue((boolean)actual.hasNext());
        Assertions.assertSame((Object)event3, (Object)actual.peek());
        Assertions.assertSame((Object)event3, (Object)actual.next());
        Assertions.assertEquals((long)2L, (long)actual.getLastSequenceNumber());
        Assertions.assertFalse((boolean)actual.hasNext());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readEvents("aggregate", 2L);
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readEvents("aggregate", 3L);
    }

    @Test
    void aggregateEventsAreReadFromFirstSequenceNumberActiveOnly() {
        GenericDomainEventMessage event1 = new GenericDomainEventMessage("type", "aggregate", 0L, (Object)"test1");
        GenericDomainEventMessage snapshotEvent = new GenericDomainEventMessage("type", "aggregate", 1L, (Object)"test3");
        GenericDomainEventMessage event3 = new GenericDomainEventMessage("type", "aggregate", 2L, (Object)"test4");
        Mockito.when((Object)this.historicStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.anyLong())).thenReturn((Object)DomainEventStream.empty());
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)0L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{event1, snapshotEvent, event3}));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)1L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage[])new DomainEventMessage[]{snapshotEvent, event3}));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.eq((long)2L))).thenReturn((Object)DomainEventStream.of((DomainEventMessage)event3));
        Mockito.when((Object)this.activeStorage.readEvents((String)Mockito.eq((Object)"aggregate"), Mockito.longThat(l -> l > 2L))).thenReturn((Object)DomainEventStream.empty());
        DomainEventStream actual = this.testSubject.readEvents("aggregate", 2L);
        ((EventStorageEngine)Mockito.verify((Object)this.activeStorage, (VerificationMode)Mockito.never())).readEvents(Mockito.anyString(), Mockito.anyLong());
        Assertions.assertTrue((boolean)actual.hasNext());
        Assertions.assertSame((Object)event3, (Object)actual.peek());
        Assertions.assertSame((Object)event3, (Object)actual.next());
        Assertions.assertEquals((long)2L, (long)actual.getLastSequenceNumber());
        Assertions.assertFalse((boolean)actual.hasNext());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.historicStorage, this.activeStorage});
        ((EventStorageEngine)inOrder.verify((Object)this.historicStorage)).readEvents("aggregate", 2L);
        ((EventStorageEngine)inOrder.verify((Object)this.activeStorage)).readEvents("aggregate", 2L);
    }
}

